/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightPassengerTypeData;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class UpdateReservationAndTicketsParametersProcessor
extends BaseProcessor {
    private boolean skipReservationUpdate;
    private boolean futureProducts;

    public void configure(Map<String, String> parameters) {
        this.skipReservationUpdate = Boolean.parseBoolean(IbusConfigurationHelper.getOptionalParameter(parameters, (String)"skip-reservation-update", (String)"false"));
        this.futureProducts = Boolean.parseBoolean(IbusConfigurationHelper.getOptionalParameter(parameters, (String)"future-products", (String)"false"));
    }

    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GDSParameters params = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        EntityReference salesPoint = sc.getSalesPoint();
        if (!this.skipReservationUpdate) {
            reservation.setBookingAgent(sc.getAgent());
            reservation.setSalesPoint(salesPoint);
            reservation.setSubagency(sc.getSubagency());
            reservation.setType(ReservationType.IBE);
            reservation.setResDate(new Date());
            reservation.setPricingDate(new Date());
            reservation.getGdsNameInfo().setOnlineGdsAccount(gdsAccountCtr.toReference());
        }
        String ticketingPCC = PccHelper.getTicketingPccCode((GDSParameters)params);
        if (params.getBlankOwner() == null) {
            throw Xeption.forAdmin((String)"\u0432 \u0442\u043e\u0447\u043a\u0435 \u043f\u0440\u043e\u0434\u0430\u0436 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u0430 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430 {1}, \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {2}", (Object[])new Object[]{salesPoint, flight.getCarrier(), flight.getGds()});
        }
        EntityReference blankOwnerRef = params.getBlankOwner();
        EntityContainer blankOwnerCtr = EntityStorage.get().resolve(blankOwnerRef);
        if (blankOwnerCtr == null) {
            throw Xeption.forAdmin((String)"\u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u0430 {0} \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445", (Object[])new Object[]{blankOwnerRef});
        }
        if (((Organization)blankOwnerCtr.getEntity()).getAirline() == null) {
            throw Xeption.forAdmin((String)"\u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f", (Object[])new Object[]{((Organization)blankOwnerCtr.getEntity()).getCode()});
        }
        Airline blankOwnerAirline = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwnerCtr.getEntity()).getAirline());
        if (blankOwnerAirline == null) {
            throw Xeption.forAdmin((String)"\u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f {0}, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0430\u044f \u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c {1}, \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435", (Object[])new Object[]{((Organization)blankOwnerCtr.getEntity()).getAirline(), ((Organization)blankOwnerCtr.getEntity()).getCode()});
        }
        if (StringUtils.isBlank((String)blankOwnerAirline.getAirlineNumber())) {
            throw Xeption.forAdmin((String)"\u0443 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438 {0}, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0430\u044f \u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c {1}, \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439 \u043a\u043e\u0434", (Object[])new Object[]{((Organization)blankOwnerCtr.getEntity()).getAirline(), ((Organization)blankOwnerCtr.getEntity()).getCode()});
        }
        DictionaryReference blankTypeRef = BookingHelper.getBlankType((EntityReference)blankOwnerRef, (boolean)true);
        List<Product> products = this.futureProducts ? GDSHelper.getProducts(reservation.getFutureProducts()) : GDSHelper.getAllEffectiveProducts(reservation);
        for (Product ticket : products) {
            if (ticket.getNextProduct() != null) continue;
            ticket.setCarrierNumber(((Airline)DictionaryCache.get().resolveReference(ticket.getCarrier())).getAirlineNumber());
            ticket.setEticket(true);
            ticket.setTicketType(TicketType.OWN);
            ticket.setCashier(sc.getAgent());
            ticket.setCashierCode(((Person)EntityStorage.get().resolve(sc.getAgent()).getEntity()).getCode());
            ticket.setSalesPoint(salesPoint);
            AirProductHelper.setSalesChain((Product)ticket, (SalesChain)flight.getSalesChain());
            ticket.setBlankOwnerRef(blankOwnerRef);
            ticket.setBlankOwnerNumber(blankOwnerAirline.getAirlineNumber());
            ticket.setBlankType(blankTypeRef);
            if (!StringUtils.isBlank((String)ticketingPCC)) {
                ticket.setPcc(ticketingPCC);
                if (StringUtils.isBlank((String)ticket.getValidatorCode())) {
                    Validator val = GDSHelper.findValidatorByPccAndBlankOwner((EntityReference<SalesPoint>)salesPoint, ticket.getPcc(), (EntityReference<Organization>)blankOwnerRef);
                    if (val == null && blankOwnerRef != null) {
                        val = GDSHelper.findValidatorByBlankOwner((EntityReference<SalesPoint>)salesPoint, (EntityReference<Organization>)blankOwnerRef);
                    }
                    if (val != null) {
                        ticket.setValidatorCode(val.getNumber());
                        ticket.setValidatorRef(new NestedEntityReference(salesPoint, (BaseEntity)val));
                        AirProductHelper.setSupplier((Product)ticket, (EntityReference)val.getSupplier());
                        if (ticket.getBlankOwnerRef() == null) {
                            ticket.setBlankOwnerRef(val.getBlankOwner());
                            ticket.setBlankOwnerNumber(UpdateReservationAndTicketsParametersProcessor.getBlankOwnerNumber((EntityReference<Organization>)val.getBlankOwner()));
                        }
                    }
                }
            }
            AirProductHelper.updateRecordNumbers((Product)ticket);
            FlightHelper.getPassengerTypeData((Flight)flight, (DictionaryReference)ticket.getPassengerType()).map(FlightPassengerTypeData::getStatisticalData).ifPresent(arg_0 -> ((Product)ticket).setStatisticalData(arg_0));
        }
    }

    private static String getBlankOwnerNumber(EntityReference<Organization> blankOwner) {
        EntityContainer ctr = EntityStorage.get().resolve(blankOwner);
        if (ctr == null) {
            return null;
        }
        Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)ctr.getEntity()).getAirline());
        return airline == null ? null : airline.getAirlineNumber();
    }
}

