/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.midoffice.model.AncillaryFeeCommission;
import com.gridnine.xtrip.common.midoffice.model.AncillaryFeeContractRelationData;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VirtualizeAncillaryFeesAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) throws Exception {
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Map contractsMap = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CONTRACTS_MAP);
        for (Flight flight : new ArrayList(flights)) {
            for (AncillaryFee fee : flight.getAncillaryFees()) {
                AncillaryFeesVirtualFlight virtualFlight = this.createVirtualFlight(fee, flight);
                if (virtualFlight == null) continue;
                flights.add(virtualFlight);
                contractsMap.put(virtualFlight, contractsMap.get(flight));
            }
        }
    }

    public void after(MessageContext ctx) throws Exception {
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        for (Flight flight : new ArrayList(flights)) {
            if (!(flight instanceof AncillaryFeesVirtualFlight)) continue;
            AncillaryFeesVirtualFlight vf = (AncillaryFeesVirtualFlight)flight;
            flights.remove((Object)vf);
            vf.fee.getContractRelations().clear();
            List relations = (List)flight.getContractRelations().get(vf.fee.getPassengerType());
            if (relations == null) {
                if (!isSaveRulesTraces) continue;
                builder.traceFlightLogic((BaseEntity)vf.getOriginalFlight(), MessageType.WARNING, "\u0434\u043b\u044f \u0434\u043e\u043f\u0443\u0441\u043b\u0443\u0433 \u043d\u0435 \u0431\u044b\u043b\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, \u0438\u0445 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u043d\u0435 \u0431\u0443\u0434\u0443\u0442 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b");
                continue;
            }
            for (GdsContractRelationData relation : relations) {
                AncillaryFeeContractRelationData rd = new AncillaryFeeContractRelationData();
                vf.fee.getContractRelations().add(rd);
                rd.setCurrency(relation.getGeneralData().getCurrency());
                rd.setDescription(relation.getDescription());
                rd.setPrice(relation.getServiceData().getTotalPrice());
                for (GdsCommission commission : relation.getCommissions()) {
                    AncillaryFeeCommission comm = new AncillaryFeeCommission();
                    rd.getCommissions().add(comm);
                    comm.setAmount(commission.getAmount());
                    comm.setCommissionProperties(commission.getCommissionProperties());
                    comm.setEquivalentAmount(commission.getEquivalentAmount());
                    comm.setRate(commission.getRate());
                }
            }
        }
    }

    private AncillaryFeesVirtualFlight createVirtualFlight(AncillaryFee fee, Flight flight) throws Exception {
        if (fee.getPassengerType() == null) {
            return null;
        }
        MCOCategory category = GdsDictHelper.convertToMcoCategory((AncillaryFeeType)fee.getType());
        if (category == null) {
            return null;
        }
        AncillaryFeesVirtualFlight result = new AncillaryFeesVirtualFlight();
        result.copyFrom((BaseEntity)flight, true, new HashMap());
        result.setMcoCategory(category);
        result.setFee(fee);
        result.getFares().clear();
        result.getTaxes().clear();
        result.getContractRelations().clear();
        boolean hasPassengerType = false;
        Iterator it = result.getSeats().iterator();
        while (it.hasNext()) {
            if (!fee.getPassengerType().equals((Object)((SeatPreferences)it.next()).getPassengerType())) {
                it.remove();
                continue;
            }
            hasPassengerType = true;
        }
        if (!hasPassengerType) {
            return null;
        }
        FlightFare flightFare = new FlightFare();
        result.getFares().add(flightFare);
        flightFare.setEquivalentAmount(MiscUtil.guarded((BigDecimal)fee.getEquivalentAmount()));
        flightFare.setPassengerType(fee.getPassengerType());
        flightFare.setBaseAmount(fee.getBaseAmount());
        result.getContractRelations().clear();
        result.setOriginalFlight(flight);
        return result;
    }

    public static class AncillaryFeesVirtualFlight
    extends Flight {
        private AncillaryFee fee;
        private Flight originalFlight;

        public AncillaryFee getFee() {
            return this.fee;
        }

        public void setFee(AncillaryFee fee) {
            this.fee = fee;
        }

        public Flight getOriginalFlight() {
            return this.originalFlight;
        }

        public void setOriginalFlight(Flight originalFlight) {
            this.originalFlight = originalFlight;
        }
    }
}

