/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.AircraftSeat;
import com.gridnine.xtrip.common.gds.model.AircraftSeatsMap;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.model.TravellerAircraftSeatsMap;
import com.gridnine.xtrip.common.midoffice.model.AncillaryFeeCommission;
import com.gridnine.xtrip.common.midoffice.model.AncillaryFeeContractRelationData;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.helpers.PersonName;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class VirtualizeSeatsMapAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) throws Exception {
        AircraftSeatsMap seatsMap = (AircraftSeatsMap)ctx.getObject((Enum)IBusGdsContextKeys.AIRCRAFT_SEATS_MAP);
        if (seatsMap == null) {
            return;
        }
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Flight flight = (Flight)flights.iterator().next();
        FlightSegment segment = (FlightSegment)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEGMENT);
        Map contractsMap = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CONTRACTS_MAP);
        List gdsTravellers = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_TRAVELLERS);
        for (TravellerAircraftSeatsMap travellerSeatsMap : seatsMap.getSeatsMapsByTravellers()) {
            Traveller traveller = travellerSeatsMap.getTraveller();
            GdsTraveller gdsTraveller = this.findGdsTraveller(gdsTravellers, traveller);
            Map<BigDecimal, List<AircraftSeat>> seatsPriceMap = this.groupAircraftSeatsByPrice(travellerSeatsMap);
            for (Map.Entry<BigDecimal, List<AircraftSeat>> entry : seatsPriceMap.entrySet()) {
                AircraftSeatsVirtualFlight virtualFlight = this.createVirtualFlight(flight, segment, gdsTraveller, entry.getKey(), entry.getValue());
                if (virtualFlight == null) continue;
                flights.add(virtualFlight);
                contractsMap.put(virtualFlight, contractsMap.get(flight));
            }
        }
    }

    public void after(MessageContext ctx) {
        AircraftSeatsMap seatsMap = (AircraftSeatsMap)ctx.getObject((Enum)IBusGdsContextKeys.AIRCRAFT_SEATS_MAP);
        if (seatsMap == null) {
            return;
        }
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        for (Flight flight : new ArrayList(flights)) {
            if (!(flight instanceof AircraftSeatsVirtualFlight)) continue;
            AircraftSeatsVirtualFlight vf = (AircraftSeatsVirtualFlight)flight;
            flights.remove((Object)vf);
            List relations = (List)flight.getContractRelations().get(((SeatPreferences)flight.getSeats().iterator().next()).getPassengerType());
            if (relations == null) {
                if (!isSaveRulesTraces) continue;
                builder.traceFlightLogic((BaseEntity)vf.getOriginalFlight(), MessageType.WARNING, "\u0434\u043b\u044f \u0434\u043e\u043f\u0443\u0441\u043b\u0443\u0433 \u043d\u0435 \u0431\u044b\u043b\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, \u0438\u0445 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u043d\u0435 \u0431\u0443\u0434\u0443\u0442 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b");
                continue;
            }
            for (GdsContractRelationData relation : relations) {
                AncillaryFeeContractRelationData rd = new AncillaryFeeContractRelationData();
                vf.getAircraftSeats().stream().map(AircraftSeat::getContractRelations).forEach(contractRelations -> contractRelations.add(rd));
                rd.setCurrency(relation.getGeneralData().getCurrency());
                rd.setDescription(relation.getDescription());
                rd.setPrice(relation.getServiceData().getTotalPrice());
                for (GdsCommission commission : relation.getCommissions()) {
                    AncillaryFeeCommission comm = new AncillaryFeeCommission();
                    rd.getCommissions().add(comm);
                    comm.setAmount(commission.getAmount());
                    comm.setCommissionProperties(commission.getCommissionProperties());
                    comm.setEquivalentAmount(commission.getEquivalentAmount());
                    comm.setRate(commission.getRate());
                }
            }
        }
    }

    private Map<BigDecimal, List<AircraftSeat>> groupAircraftSeatsByPrice(TravellerAircraftSeatsMap travellerSeatsMap) {
        return travellerSeatsMap.getDecks().stream().flatMap(deck -> deck.getSeatsRows().stream()).flatMap(seatsRow -> seatsRow.getSeats().stream()).filter(seat -> seat.getEquivalentAmount() != null).collect(Collectors.groupingBy(AircraftSeat::getEquivalentAmount, Collectors.mapping(Function.identity(), Collectors.toList())));
    }

    private GdsTraveller findGdsTraveller(List<GdsTraveller> gdsTravellers, Traveller traveller) {
        return gdsTravellers.stream().filter(gdsTraveller -> gdsTraveller.getTravellerUid().equals(traveller.getUid())).findFirst().orElseThrow(() -> {
            PersonName personName = ProfileHelper.personName((Traveller)traveller);
            return Xeption.forDeveloper((String)String.format("unexpected result: traveller %s %s is not found", personName.getFirstName(), personName.getLastName()), (Object[])new Object[0]);
        });
    }

    private AircraftSeatsVirtualFlight createVirtualFlight(Flight flight, FlightSegment segment, GdsTraveller gdsTraveller, BigDecimal seatsPrice, List<AircraftSeat> seats) throws Exception {
        AircraftSeatsVirtualFlight result = new AircraftSeatsVirtualFlight();
        result.copyFrom((BaseEntity)flight, true, new HashMap());
        result.setMcoCategory(MCOCategory.SEAT_RESERVATION);
        result.setAircraftSeats(seats);
        result.getFares().clear();
        result.getTaxes().clear();
        result.getContractRelations().clear();
        boolean hasPassengerType = false;
        Iterator it = result.getSeats().iterator();
        while (it.hasNext()) {
            if (!gdsTraveller.getPassengerType().equals((Object)((SeatPreferences)it.next()).getPassengerType())) {
                it.remove();
                continue;
            }
            hasPassengerType = true;
        }
        if (!hasPassengerType) {
            return null;
        }
        FlightFare flightFare = new FlightFare();
        result.getFares().add(flightFare);
        flightFare.setEquivalentAmount(MiscUtil.guarded((BigDecimal)seatsPrice));
        flightFare.setPassengerType(gdsTraveller.getPassengerType());
        result.getContractRelations().clear();
        result.setOriginalFlight(flight);
        return result;
    }

    private static class AircraftSeatsVirtualFlight
    extends Flight {
        private Flight originalFlight;
        private List<AircraftSeat> aircraftSeats;

        private AircraftSeatsVirtualFlight() {
        }

        public List<AircraftSeat> getAircraftSeats() {
            return this.aircraftSeats;
        }

        public void setAircraftSeats(List<AircraftSeat> aircraftSeats) {
            this.aircraftSeats = aircraftSeats;
        }

        public Flight getOriginalFlight() {
            return this.originalFlight;
        }

        public void setOriginalFlight(Flight originalFlight) {
            this.originalFlight = originalFlight;
        }
    }
}

