/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.CollectedContractData;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECManager;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ContractorDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class VirtualizeSeparateBspContractsAdvice
extends BaseAdvice {
    private static final EntityReference<ContractRelationDescription> contractRelationRef = new EntityReference("temp-vendor-to-vendor-relation", ContractRelationDescription.class, "\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 vendor-to-vendor  (\u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c)");
    private static final EntityReference<ContractorDescription> superSupplierRef = new EntityReference("temp-super-supplier", ContractorDescription.class, "\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 super supplier  (\u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c)");

    public void before(MessageContext ctx) throws Exception {
        Map separateContracts = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.SEPARATE_BSP_CONTRACTS_MAP);
        HashMap<Flight, SalesChain> originalSalesChains = new HashMap<Flight, SalesChain>(separateContracts.size());
        ctx.putObject((Enum)IBusGdsContextKeys.ORIGINAL_SALES_CHAINS, originalSalesChains);
        if (separateContracts.isEmpty()) {
            return;
        }
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        for (Map.Entry entry : separateContracts.entrySet()) {
            Flight flight = (Flight)entry.getKey();
            CollectedContractData contractData = (CollectedContractData)entry.getValue();
            SalesChain newSalesChain = VirtualizeSeparateBspContractsAdvice.getNewSalesChain(flight.getSalesChain(), (EntityReference<Organization>)flight.getBlankOwner());
            EntityContainer newSalesChainDescrCtr = EntityStorage.get().resolve(newSalesChain.getDescription());
            originalSalesChains.put(flight, flight.getSalesChain());
            flight.setSalesChain(newSalesChain);
            if (flight.getContractRelations() != null) {
                for (List relations : flight.getContractRelations().values()) {
                    GdsContractRelationData relation = (GdsContractRelationData)XCloneHelper.clone((XCloneable)((XCloneable)relations.get(0)), (boolean)true);
                    relation.setDescription((EntityReference)((SalesChainDescription)newSalesChainDescrCtr.getEntity()).getContractRelations().get(0));
                    relations.add(0, relation);
                }
            }
            Map contractsMap = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CONTRACTS_MAP);
            Map flightContractsMap = (Map)contractsMap.get(flight);
            flightContractsMap.put(((SalesChainDescription)newSalesChainDescrCtr.getEntity()).getContractRelations().get(0), contractData);
            if (!isSaveRulesTraces) continue;
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b \u0441 BSP: %s", contractData.getContractContainers().stream().map(ctr -> ((Contract)ctr.getEntity()).toString()).collect(Collectors.toList())));
        }
    }

    public void after(MessageContext ctx) throws Exception {
        Map originalSalesChains = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.ORIGINAL_SALES_CHAINS);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        for (Flight flight : originalSalesChains.keySet()) {
            flight.setSalesChain((SalesChain)originalSalesChains.get(flight));
            for (List contractRelations : flight.getContractRelations().values()) {
                GdsContractRelationData bspRelation = (GdsContractRelationData)contractRelations.remove(0);
                GdsContractRelationData supplierRelation = (GdsContractRelationData)contractRelations.get(0);
                List commissions = bspRelation.getCommissions();
                Collection bspCommissions = GeneralProductHelper.filterCommissions((Collection)commissions, (Set)GeneralProductHelper.commissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, (Set)GeneralProductHelper.standardCommissionCategories);
                if (builder != null && isSaveRulesTraces) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("%s (%s unfiltered) commissions calculated for virtualized relation", Integer.toString(bspCommissions.size()), Integer.toString(commissions.size())));
                }
                ArrayList lst = new ArrayList(bspCommissions);
                lst.addAll(supplierRelation.getCommissions());
                supplierRelation.getCommissions().clear();
                supplierRelation.getCommissions().addAll(lst);
            }
        }
    }

    private static SalesChain getNewSalesChain(SalesChain salesChain, EntityReference<Organization> blankOwnerRef) throws Exception {
        EntityContainer salesChainDescrCtr = EntityStorage.get().resolve(salesChain.getDescription());
        int size = ((SalesChainDescription)salesChainDescrCtr.getEntity()).getContractRelations().size();
        String newSalesChainUid = String.format("temp-sales-chain-%s", Integer.toString(size));
        EntityReference newSalesChainRef = new EntityReference(newSalesChainUid, SalesChainDescription.class, newSalesChainUid);
        EntityReference supplierDescrRef = GeneralProductHelper.findPredefinedContractorDescription((PredefinedContractorType)PredefinedContractorType.SUPPLIER);
        EntityContainer newSalesChainDescCtr = EntityStorage.get().resolve(newSalesChainRef);
        if (newSalesChainDescCtr == null) {
            EntityContainer contractRelationCtr;
            EntityContainer superSupplierDescrCtr = EntityStorage.get().resolve(superSupplierRef);
            if (superSupplierDescrCtr == null) {
                superSupplierDescrCtr = new EntityContainer(superSupplierRef.getType(), superSupplierRef.getUid());
                ((ContractorDescription)superSupplierDescrCtr.getEntity()).getName().setStringValue(supplierDescrRef.getCaption());
                ((ContractorDescription)superSupplierDescrCtr.getEntity()).setPredefinedType(PredefinedContractorType.SUPER_SUPPLIER);
                superSupplierDescrCtr = VirtualizeSeparateBspContractsAdvice.saveAdnInvalidateCache(superSupplierDescrCtr, false);
            }
            if ((contractRelationCtr = EntityStorage.get().resolve(contractRelationRef)) == null) {
                contractRelationCtr = new EntityContainer(contractRelationRef.getType(), contractRelationRef.getUid());
                ((ContractRelationDescription)contractRelationCtr.getEntity()).setSupplier(superSupplierRef);
                ((ContractRelationDescription)contractRelationCtr.getEntity()).setCustomer(supplierDescrRef);
                contractRelationCtr = VirtualizeSeparateBspContractsAdvice.saveAdnInvalidateCache(contractRelationCtr, false);
            }
            newSalesChainDescCtr = new EntityContainer(SalesChainDescription.class, newSalesChainUid);
            ((SalesChainDescription)newSalesChainDescCtr.getEntity()).getContractRelations().add(contractRelationRef);
            ((SalesChainDescription)newSalesChainDescCtr.getEntity()).getContractRelations().addAll(((SalesChainDescription)salesChainDescrCtr.getEntity()).getContractRelations());
            newSalesChainDescCtr = VirtualizeSeparateBspContractsAdvice.saveAdnInvalidateCache(newSalesChainDescCtr, false);
        }
        SalesChain result = new SalesChain();
        result.setDescription(newSalesChainRef);
        Contractor blankOwnerContractor = new Contractor();
        blankOwnerContractor.setDescription(superSupplierRef);
        blankOwnerContractor.setContractor(blankOwnerRef);
        result.getContractors().add(blankOwnerContractor);
        result.getContractors().addAll(salesChain.getContractors());
        return result;
    }

    private static <E extends BaseEntity> EntityContainer<E> saveAdnInvalidateCache(EntityContainer<E> ctr, boolean withCheckPoint) throws Exception {
        AECManager manager = (AECManager)Environment.getPublished(EntityCacheManager.class);
        manager.invalidate(new ModificationData((XSerializable)ctr.toReference(), Collections.emptyList()));
        return EntityStorage.get().save(ctr, false);
    }
}

