/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.afs20;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.afs20.AfsHelper;
import com.gridnine.xtrip.server.gds.ibus.afs20.IBusGdsAfsKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;

public class AfsFallbackProcessor
extends BaseProcessor {
    private boolean includeTaxes;

    public void configure(Map<String, String> parameters) {
        this.includeTaxes = Boolean.parseBoolean(parameters.get("include-taxes"));
    }

    public void process(MessageContext ctx) throws Exception {
        AFSType afsType = (AFSType)ctx.getMandatoryObject((Enum)IBusGdsAfsKeys.AFS_TYPE);
        Boolean isTicketing = (Boolean)ctx.getMandatoryObject((Enum)IBusGdsAfsKeys.AFS_IS_TICKETING);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Collection productUids = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AFS_PRODUCT_UIDS_TO_UPDATE);
        for (BaseProduct bp : reservation.getProducts()) {
            if (!productUids.contains(bp.getUid())) continue;
            Product product = (Product)bp;
            BigDecimal value = AfsHelper.getProductPrice(product, this.includeTaxes);
            StatisticsHelper.smartSetPricingAfsValue((Product)product, (AFSType)afsType, (boolean)isTicketing, (Double)value.doubleValue());
        }
    }
}

