/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.afs20;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AfsHelper {
    public static BigDecimal getProductPrice(Product product, boolean includeTaxes) {
        BigDecimal value = AirProductHelper.getEquivalentFare((Product)product);
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        if (includeTaxes) {
            value = value.add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product));
        }
        return value;
    }

    public static Optional<String> getBrandId(FareDetails fareDetails) {
        return Optional.ofNullable(fareDetails).map(FareDetails::getPricingParameters).map(FarePricingParameters::getBrandId);
    }

    private static String clearFareBasis(String fareBasis) {
        int i = fareBasis.indexOf(47);
        return i >= 0 ? fareBasis.substring(0, i) : fareBasis;
    }

    public static boolean flightAndFareMatches(Flight flight, Collection<Product> products) {
        List actualFlights = FlightHelper.getSegments((Flight)flight).stream().map(fs -> Arrays.asList(fs.getAirline(), fs.getFlightNumber(), fs.getDateBegin().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())).collect(Collectors.toList());
        for (Product product : products) {
            List actualRbds;
            List actualBrandIds;
            List requiredFlights = AirProductHelper.getSegments((Collection)product.getSegmentTariffs()).stream().map(s -> Arrays.asList(s.getAirline(), s.getFlightNo(), s.getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())).collect(Collectors.toList());
            if (!requiredFlights.equals(actualFlights)) {
                return false;
            }
            List requiredBrandIds = AirProductHelper.getProductSegmentsStream((Product)product).map(seg -> AfsHelper.getBrandId(seg.getFareDetails()).orElse(AfsHelper.clearFareBasis(seg.getFareBasis()))).collect(Collectors.toList());
            if (!requiredBrandIds.equals(actualBrandIds = FlightHelper.getSegments((Flight)flight).stream().map(fs -> FlightHelper.getFareInfo((FlightSegment)fs, (DictionaryReference)product.getPassengerType())).map(fi -> AfsHelper.getBrandId(fi.getFareDetails()).orElse(AfsHelper.clearFareBasis(fi.getFareBasis()))).collect(Collectors.toList()))) {
                return false;
            }
            List requiredRbds = AirProductHelper.getProductSegmentsStream((Product)product).map(Segment::getClassOfSvcCode).collect(Collectors.toList());
            if (requiredRbds.equals(actualRbds = FlightHelper.getSegments((Flight)flight).stream().map(FlightSegment::getBookingClass).collect(Collectors.toList()))) continue;
            return false;
        }
        return true;
    }
}

