/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.afs20;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.gds.ibus.afs20.IBusGdsAfsKeys;
import com.gridnine.xtrip.server.ibus.components.AdviceOnExceptionCallback;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfsLogger {
    private static final Logger logger = LoggerFactory.getLogger(AfsLogger.class);

    public static void logSuccess(MessageContext ctx) {
        try {
            Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
            AFSType afsType = (AFSType)ctx.getMandatoryObject((Enum)IBusGdsAfsKeys.AFS_TYPE);
            logger.info("gdsAccountClassName={}, afs={}, licence={}, cause=success, pnr={}", new Object[]{reservation.getGdsNameInfo().getOnlineGdsAccount().getType().getSimpleName(), afsType, ((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration().getProperty("licenceKey"), CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)});
        }
        catch (Throwable t) {
            logger.error("failed logging success", t);
        }
    }

    public static void logFallback(MessageContext ctx) {
        try {
            Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
            AFSType afsType = (AFSType)ctx.getMandatoryObject((Enum)IBusGdsAfsKeys.AFS_TYPE);
            AdviceOnExceptionCallback callback = (AdviceOnExceptionCallback)ctx.getObject((Enum)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
            String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
            if (callback != null && callback.getException() != null) {
                logger.warn("gdsAccountClassName={}, afs={}, licence={}, cause=fallback, pnr={}", new Object[]{reservation.getGdsNameInfo().getOnlineGdsAccount().getType().getSimpleName(), afsType, ((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration().getProperty("licenceKey"), recordLocator, callback.getException()});
            } else {
                logger.warn("gdsAccountClassName={}, afs={}, licence={}, cause=fallback, pnr={}", new Object[]{reservation.getGdsNameInfo().getOnlineGdsAccount().getType().getSimpleName(), afsType, ((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration().getProperty("licenceKey"), recordLocator});
            }
        }
        catch (Throwable t) {
            logger.error("failed logging fallback", t);
        }
    }
}

