/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.afs20;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.afs20.IBusGdsAfsKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collection;

public class AfsValueFromFlightProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Boolean isTicketing = (Boolean)ctx.getMandatoryObject((Enum)IBusGdsAfsKeys.AFS_IS_TICKETING);
        Collection products = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCTS);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        for (Product product : products) {
            BigDecimal value = FlightHelper.getEquivalentFare((Flight)flight, (DictionaryReference)product.getPassengerType()).add(FlightHelper.getEquivalentTaxSum((Flight)flight, (DictionaryReference)product.getPassengerType()));
            StatisticsHelper.smartSetPricingAfsValue((Product)product, (AFSType)AFSType.P3D, (boolean)isTicketing, (Double)value.doubleValue());
        }
    }
}

