/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.afs20;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.afs20.IBusGdsAfsKeys;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class IsP3DCalculatedProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        Boolean isTicketing;
        Collection productUids;
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        if (this.isP3dValuesExists(reservation, productUids = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AFS_PRODUCT_UIDS_TO_UPDATE), isTicketing = (Boolean)ctx.getMandatoryObject((Enum)IBusGdsAfsKeys.AFS_IS_TICKETING))) {
            return Boolean.toString(false);
        }
        if (!StringUtils.isBlank((String)reservation.getAccountCode()) || !StringUtils.isBlank((String)reservation.getCorporateId())) {
            return Boolean.toString(true);
        }
        for (Product product : AirProductHelper.getProducts((Reservation)reservation)) {
            if (product.getTripartiteContractDetails().getTripartiteContract() != null) {
                return Boolean.toString(true);
            }
            if (product.getTripartiteContractDetails().getPublicFareDiscount() == null) continue;
            return Boolean.toString(true);
        }
        return Boolean.toString(false);
    }

    private boolean isP3dValuesExists(Reservation reservation, Collection<String> productUids, boolean isTicketing) {
        for (Product product : AirProductHelper.getProducts((Reservation)reservation)) {
            if (!productUids.contains(product.getUid())) continue;
            if (product.getStatisticalData() == null) {
                return false;
            }
            if (isTicketing && product.getStatisticalData().getP3dTkt() == null) {
                return false;
            }
            if (isTicketing || product.getStatisticalData().getP3dBkg() != null) continue;
            return false;
        }
        return true;
    }
}

