/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.airline;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineActionSet;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CommonAirlineApplyRulesToFlightsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List proxies = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULE_PROXIES);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = builder != null && gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        for (RuleProxy proxy : proxies) {
            PenaltiesInfo penaltiesInfo;
            Flight flight = ((FlightPropertySet)((Object)proxy.getPropertySet())).getFlight();
            if (((CommonAirlineActionSet)proxy.getActionSet()).isExcludeFromResult()) {
                flights.remove(flight);
                if (isSaveRulesTraces) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "\u043f\u0435\u0440\u0435\u043b\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d \u0438\u0437 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u043f\u043e\u0438\u0441\u043a\u0430 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e \u043e\u0431\u0449\u0438\u043c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u043c \u0410\u041a");
                }
            }
            DictionaryReference<PassengerType> passengerTypeRef = ((FlightPropertySet)((Object)proxy.getPropertySet())).getPassengerTypeRef();
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            flight.setInfoMessage(as.getMessageOnFlightCard() != null ? as.getMessageOnFlightCard().toString() : null);
            if (flight.getSegmentTariffs().size() == 1 && ((FlightSegmentTariff)flight.getSegmentTariffs().get(0)).getSegments().size() == 1) {
                FlightSegment fs = (FlightSegment)((FlightSegmentTariff)flight.getSegmentTariffs().get(0)).getSegments().get(0);
                FareInfo fareInfo = null;
                for (FareInfo fi : fs.getFareInfos()) {
                    if (!MiscUtil.equals((Object)fi.getPassengerType(), passengerTypeRef)) continue;
                    fareInfo = fi;
                    break;
                }
                if (fareInfo == null) {
                    throw Xeption.forDeveloper((String)"fare info not found for {0}", (Object[])new Object[]{passengerTypeRef});
                }
                if (fareInfo.getFareDetails() == null) {
                    fareInfo.setFareDetails(new FareDetails());
                }
                if (as.getLuggageInfo() != null) {
                    fareInfo.getFareDetails().setLuggageInfo((ExtendedLuggageInfo)XCloneHelper.clone((XCloneable)as.getLuggageInfo()));
                }
                if (as.getPaidLuggageInfo() != null) {
                    fareInfo.getFareDetails().setPaidLuggageInfo((ExtendedLuggageInfo)XCloneHelper.clone((XCloneable)as.getPaidLuggageInfo()));
                }
                if (as.getPaidLuggagePrice() != null) {
                    fareInfo.getFareDetails().setPaidLuggagePrice((Money)XCloneHelper.clone((XCloneable)as.getPaidLuggagePrice()));
                }
                if (as.getCabinLuggageInfo() != null && fareInfo.getFareDetails().getCabinLuggageInfo() == null) {
                    fareInfo.getFareDetails().setCabinLuggageInfo((ExtendedLuggageInfo)XCloneHelper.clone((XCloneable)as.getCabinLuggageInfo()));
                }
                if (as.getPaidCabinLuggageInfo() != null) {
                    fareInfo.getFareDetails().setPaidCabinLuggageInfo((ExtendedLuggageInfo)XCloneHelper.clone((XCloneable)as.getPaidCabinLuggageInfo()));
                }
                if (as.getPaidCabinLuggagePrice() != null) {
                    fareInfo.getFareDetails().setPaidCabinLuggagePrice((Money)XCloneHelper.clone((XCloneable)as.getPaidCabinLuggagePrice()));
                }
                if (as.getMealService() != null) {
                    fareInfo.getFareDetails().setMealService(as.getMealService());
                }
                if (as.getBusinessLoungeAccess() != null) {
                    fareInfo.getFareDetails().setBusinessLoungeAccess(as.getBusinessLoungeAccess());
                }
                if (as.getClassUpgradeAvailable() != null) {
                    fareInfo.getFareDetails().setClassUpgradeAvailable(as.getClassUpgradeAvailable());
                }
                if (as.getExtraMileageBonus() != null) {
                    fareInfo.getFareDetails().setExtraMileageBonus(as.getExtraMileageBonus());
                }
                if (as.getPriorityBoarding() != null) {
                    fareInfo.getFareDetails().setPriorityBoarding(as.getPriorityBoarding());
                }
                if (as.getSeatChoice() != null) {
                    fareInfo.getFareDetails().setSeatChoice(as.getSeatChoice());
                }
                if (as.getTransferIncluded() != null) {
                    fareInfo.getFareDetails().setTransferIncluded(as.getTransferIncluded());
                }
                if (as.getPricingParameters() != null) {
                    if (fareInfo.getFareDetails().getPricingParameters() == null) {
                        fareInfo.getFareDetails().setPricingParameters(new FarePricingParameters());
                    }
                    fareInfo.getFareDetails().getPricingParameters().setDefaultPricing(as.getPricingParameters().isDefaultPricing());
                    fareInfo.getFareDetails().getPricingParameters().setPublicFare(as.getPricingParameters().getPublicFare());
                    fareInfo.getFareDetails().getPricingParameters().setRefundableAny(as.getPricingParameters().getRefundableAny());
                }
                if (fareInfo.getPenaltiesInfo() == null) {
                    fareInfo.setPenaltiesInfo(new PenaltiesInfo());
                }
                if (as.getRefundableBeforeDepartureSegment() != null) {
                    fareInfo.getPenaltiesInfo().setRefundableBeforeDeparture(as.getRefundableBeforeDepartureSegment());
                }
                if (as.getRefundableAfterDepartureSegment() != null) {
                    fareInfo.getPenaltiesInfo().setRefundableAfterDeparture(as.getRefundableAfterDepartureSegment());
                }
                if (as.getExchangableBeforeDepartureSegment() != null) {
                    fareInfo.getPenaltiesInfo().setExchangableBeforeDeparture(as.getExchangableBeforeDepartureSegment());
                }
                if (as.getExchangableAfterDepartureSegment() != null) {
                    fareInfo.getPenaltiesInfo().setExchangableAfterDeparture(as.getExchangableAfterDepartureSegment());
                }
                if (as.getRefundBeforeDepartureSegment() != null) {
                    fareInfo.getPenaltiesInfo().setRefundBeforeDeparture((Money)XCloneHelper.clone((XCloneable)as.getRefundBeforeDepartureSegment()));
                }
                if (as.getRefundAfterDepartureSegment() != null) {
                    fareInfo.getPenaltiesInfo().setRefundAfterDeparture((Money)XCloneHelper.clone((XCloneable)as.getRefundAfterDepartureSegment()));
                }
                if (as.getExchangeBeforeDepartureSegment() != null) {
                    fareInfo.getPenaltiesInfo().setExchangeBeforeDeparture((Money)XCloneHelper.clone((XCloneable)as.getExchangeBeforeDepartureSegment()));
                }
                if (as.getExchangeAfterDepartureSegment() != null) {
                    fareInfo.getPenaltiesInfo().setExchangeAfterDeparture((Money)XCloneHelper.clone((XCloneable)as.getExchangeAfterDepartureSegment()));
                }
                if (as.getDisplayName() != null) {
                    L10nStringHelper.copy((L10nString)as.getDisplayName(), (L10nString)fareInfo.getFareDetails().getDisplayBrandName());
                }
            }
            if ((penaltiesInfo = (PenaltiesInfo)flight.getPenaltiesInfos().get(passengerTypeRef)) == null) {
                penaltiesInfo = new PenaltiesInfo();
                flight.getPenaltiesInfos().put(passengerTypeRef, penaltiesInfo);
            }
            if (as.getRefundableBeforeDepartureTicket() != null) {
                penaltiesInfo.setRefundableBeforeDeparture(as.getRefundableBeforeDepartureTicket());
            }
            if (as.getRefundableAfterDepartureTicket() != null) {
                penaltiesInfo.setRefundableAfterDeparture(as.getRefundableAfterDepartureTicket());
            }
            if (as.getExchangableBeforeDepartureTicket() != null) {
                penaltiesInfo.setExchangableBeforeDeparture(as.getExchangableBeforeDepartureTicket());
            }
            if (as.getExchangableAfterDepartureTicket() != null) {
                penaltiesInfo.setExchangableAfterDeparture(as.getExchangableAfterDepartureTicket());
            }
            if (as.getRefundBeforeDepartureTicket() != null) {
                penaltiesInfo.setRefundBeforeDeparture((Money)XCloneHelper.clone((XCloneable)as.getRefundBeforeDepartureTicket()));
            }
            if (as.getRefundAfterDepartureTicket() != null) {
                penaltiesInfo.setRefundAfterDeparture((Money)XCloneHelper.clone((XCloneable)as.getRefundAfterDepartureTicket()));
            }
            if (as.getRefundBeforeDepartureTicketFarePercent() != null) {
                penaltiesInfo.setRefundBeforeDepartureFarePercent(as.getRefundBeforeDepartureTicketFarePercent());
            }
            if (as.getRefundAfterDepartureTicketFarePercent() != null) {
                penaltiesInfo.setRefundAfterDepartureFarePercent(as.getRefundAfterDepartureTicketFarePercent());
            }
            if (as.getExchangeBeforeDepartureTicket() != null) {
                penaltiesInfo.setExchangeBeforeDeparture((Money)XCloneHelper.clone((XCloneable)as.getExchangeBeforeDepartureTicket()));
            }
            if (as.getExchangeAfterDepartureTicket() != null) {
                penaltiesInfo.setExchangeAfterDeparture((Money)XCloneHelper.clone((XCloneable)as.getExchangeAfterDepartureTicket()));
            }
            if (as.getExchangeBeforeDepartureTicketFarePercent() != null) {
                penaltiesInfo.setExchangeBeforeDepartureFarePercent(as.getExchangeBeforeDepartureTicketFarePercent());
            }
            if (as.getExchangeAfterDepartureTicketFarePercent() != null) {
                penaltiesInfo.setExchangeAfterDepartureFarePercent(as.getExchangeAfterDepartureTicketFarePercent());
            }
            if (!as.getVisaRequirements().isEmpty()) {
                flight.getVisaRequirements().clear();
                flight.getVisaRequirements().addAll(XCloneHelper.cloneList(new ArrayList(as.getVisaRequirements())));
            }
            flight.setOrganizationAirlineBonusCardsParameters(as.getOrganizationAirlineBonusCardsParameters());
        }
    }
}

