/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.airline;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.PenaltiesInfoHelper;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineActionSet;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.GdsProductPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.EntityOperationTracingPartBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonAirlineApplyRulesToReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Product product;
        List proxies = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULE_PROXIES);
        EntityOperationTracingPartBuilder builder = (EntityOperationTracingPartBuilder)ctx.getObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_PART_BUILDER);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        HashMap<Product, ArrayList<PenaltiesInfo>> pm = new HashMap<Product, ArrayList<PenaltiesInfo>>();
        boolean hasVirtualSegment = false;
        for (RuleProxy proxy : proxies) {
            Product product2 = ((GdsProductPropertySet)((Object)proxy.getPropertySet())).getProduct();
            if (!product2.getUid().startsWith("virtual-seg")) continue;
            hasVirtualSegment = true;
            break;
        }
        int segmentsCount = 0;
        int segmentTariffsCount = 0;
        for (RuleProxy ruleProxy : proxies) {
            product = ((GdsProductPropertySet)((Object)ruleProxy.getPropertySet())).getProduct();
            CommonAirlineActionSet as = (CommonAirlineActionSet)ruleProxy.getActionSet();
            if (builder != null) {
                if (product.getUid().startsWith("virtual-st")) {
                    builder.traceLogic(String.format("\nAnalizing %s virtual segment tariff product", segmentTariffsCount + 1));
                    reservation.getProducts().remove(product);
                    ++segmentTariffsCount;
                } else if (product.getUid().startsWith("virtual-seg")) {
                    builder.traceLogic(String.format("\nAnalyzing %s virtual segment product", segmentsCount + 1));
                    reservation.getProducts().remove(product);
                    ++segmentsCount;
                } else {
                    builder.traceLogic(String.format("\nAnalizing product %s", AirProductHelper.getProductTitle((Product)product)));
                    segmentsCount = 0;
                    segmentTariffsCount = 0;
                }
                RuleSet rules = (RuleSet)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULES);
                for (String ruleUid : ruleProxy.getAppliedRules()) {
                    RuleSettings rs = (RuleSettings)CollectionUtil.find((Iterable)rules.getRules(), (String)ruleUid);
                    if (rs == null) continue;
                    builder.traceLogic(String.format("\nrule %s \"%s\" was applied: %s", Integer.toString(rules.getRules().indexOf(rs) + 1), rs.getName(), rs.getRestrictionsInfoNoHtml()));
                }
            }
            if (product.getUid().startsWith("virtual-seg")) {
                Segment segment = (Segment)((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().get(0);
                this.updateSegmentData(segment, as);
            }
            if (!product.getUid().startsWith("virtual-seg") && !product.getUid().startsWith("virtual-st-")) {
                PenaltiesInfo penaltiesInfo = product.getPenaltiesInfo();
                if (penaltiesInfo == null) {
                    penaltiesInfo = new PenaltiesInfo();
                    product.setPenaltiesInfo(penaltiesInfo);
                }
                if (as.getRefundableBeforeDepartureTicket() != null) {
                    penaltiesInfo.setRefundableBeforeDeparture(as.getRefundableBeforeDepartureTicket());
                }
                if (as.getRefundableAfterDepartureTicket() != null) {
                    penaltiesInfo.setRefundableAfterDeparture(as.getRefundableAfterDepartureTicket());
                }
                if (as.getExchangableBeforeDepartureTicket() != null) {
                    penaltiesInfo.setExchangableBeforeDeparture(as.getExchangableBeforeDepartureTicket());
                }
                if (as.getExchangableAfterDepartureTicket() != null) {
                    penaltiesInfo.setExchangableAfterDeparture(as.getExchangableAfterDepartureTicket());
                }
                if (as.getRefundBeforeDepartureTicket() != null) {
                    penaltiesInfo.setRefundBeforeDeparture(as.getRefundBeforeDepartureTicket());
                }
                if (as.getRefundAfterDepartureTicket() != null) {
                    penaltiesInfo.setRefundAfterDeparture(as.getRefundAfterDepartureTicket());
                }
                if (as.getRefundBeforeDepartureTicketFarePercent() != null) {
                    penaltiesInfo.setRefundBeforeDepartureFarePercent(as.getRefundBeforeDepartureTicketFarePercent());
                }
                if (as.getRefundAfterDepartureTicketFarePercent() != null) {
                    penaltiesInfo.setRefundAfterDepartureFarePercent(as.getRefundAfterDepartureTicketFarePercent());
                }
                if (as.getExchangeBeforeDepartureTicket() != null) {
                    penaltiesInfo.setExchangeBeforeDeparture(as.getExchangeBeforeDepartureTicket());
                }
                if (as.getExchangeAfterDepartureTicket() != null) {
                    penaltiesInfo.setExchangeAfterDeparture(as.getExchangeAfterDepartureTicket());
                }
                if (as.getExchangeBeforeDepartureTicketFarePercent() != null) {
                    penaltiesInfo.setExchangeBeforeDepartureFarePercent(as.getExchangeBeforeDepartureTicketFarePercent());
                }
                if (as.getExchangeAfterDepartureTicketFarePercent() != null) {
                    penaltiesInfo.setExchangeAfterDepartureFarePercent(as.getExchangeAfterDepartureTicketFarePercent());
                }
                product.getReservation().getVisaRequirements().clear();
                product.getReservation().getVisaRequirements().addAll(as.getVisaRequirements());
                if (!hasVirtualSegment && product.getSegmentTariffs().size() > 0 && ((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().size() > 0) {
                    Segment segment = (Segment)((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().get(0);
                    this.updateSegmentData(segment, as);
                }
            }
            if (!product.getUid().startsWith("virtual-st-") || product.getPenaltiesInfo() == null) continue;
            String realUid = product.getUid().substring("virtual-st-".length(), product.getUid().indexOf("||"));
            Product realProduct = (Product)CollectionUtil.find((Iterable)reservation.getProducts(), (String)realUid);
            if (realProduct == null) continue;
            ArrayList<PenaltiesInfo> penaltiesInfos = (ArrayList<PenaltiesInfo>)pm.get(realProduct);
            if (penaltiesInfos == null) {
                penaltiesInfos = new ArrayList<PenaltiesInfo>();
                pm.put(realProduct, penaltiesInfos);
            }
            penaltiesInfos.add(product.getPenaltiesInfo());
        }
        for (Map.Entry entry : pm.entrySet()) {
            product = (Product)entry.getKey();
            ArrayList penaltiesInfos = new ArrayList((Collection)entry.getValue());
            CollectionUtil.sort(penaltiesInfos, (Comparator)new PenaltiesInfoComparator(product));
            product.setPenaltiesInfo((PenaltiesInfo)penaltiesInfos.get(0));
            if (builder == null) continue;
            builder.traceLogic(String.format("\nstrictest conditions are from segment tariff %s", Integer.toString(((List)entry.getValue()).indexOf(penaltiesInfos.get(0)) + 1)));
        }
    }

    private void updateSegmentData(Segment segment, CommonAirlineActionSet as) {
        if (segment.getFareDetails() == null) {
            segment.setFareDetails(new FareDetails());
        }
        if (as.getLuggageInfo() != null) {
            segment.getFareDetails().setLuggageInfo(as.getLuggageInfo());
        }
        if (as.getPaidLuggageInfo() != null) {
            segment.getFareDetails().setPaidLuggageInfo(as.getPaidLuggageInfo());
        }
        if (as.getPaidLuggagePrice() != null) {
            segment.getFareDetails().setPaidLuggagePrice(as.getPaidLuggagePrice());
        }
        if (as.getCabinLuggageInfo() != null && segment.getFareDetails().getCabinLuggageInfo() == null) {
            segment.getFareDetails().setCabinLuggageInfo(as.getCabinLuggageInfo());
        }
        if (as.getPaidCabinLuggageInfo() != null) {
            segment.getFareDetails().setPaidCabinLuggageInfo(as.getPaidCabinLuggageInfo());
        }
        if (as.getPaidCabinLuggagePrice() != null) {
            segment.getFareDetails().setPaidCabinLuggagePrice(as.getPaidCabinLuggagePrice());
        }
        if (as.getMealService() != null) {
            segment.getFareDetails().setMealService(as.getMealService());
        }
        if (as.getBusinessLoungeAccess() != null) {
            segment.getFareDetails().setBusinessLoungeAccess(as.getBusinessLoungeAccess());
        }
        if (as.getClassUpgradeAvailable() != null) {
            segment.getFareDetails().setClassUpgradeAvailable(as.getClassUpgradeAvailable());
        }
        if (as.getExtraMileageBonus() != null) {
            segment.getFareDetails().setExtraMileageBonus(as.getExtraMileageBonus());
        }
        if (as.getPriorityBoarding() != null) {
            segment.getFareDetails().setPriorityBoarding(as.getPriorityBoarding());
        }
        if (as.getSeatChoice() != null) {
            segment.getFareDetails().setSeatChoice(as.getSeatChoice());
        }
        if (as.getTransferIncluded() != null) {
            segment.getFareDetails().setTransferIncluded(as.getTransferIncluded());
        }
        if (as.getPricingParameters() != null) {
            if (segment.getFareDetails().getPricingParameters() == null) {
                segment.getFareDetails().setPricingParameters(new FarePricingParameters());
            }
            segment.getFareDetails().getPricingParameters().setDefaultPricing(as.getPricingParameters().isDefaultPricing());
            segment.getFareDetails().getPricingParameters().setPublicFare(as.getPricingParameters().getPublicFare());
            segment.getFareDetails().getPricingParameters().setRefundableAny(as.getPricingParameters().getRefundableAny());
        }
        if (segment.getPenaltiesInfo() == null) {
            segment.setPenaltiesInfo(new PenaltiesInfo());
        }
        if (as.getRefundableBeforeDepartureSegment() != null) {
            segment.getPenaltiesInfo().setRefundableBeforeDeparture(as.getRefundableBeforeDepartureSegment());
        }
        if (as.getRefundableAfterDepartureSegment() != null) {
            segment.getPenaltiesInfo().setRefundableAfterDeparture(as.getRefundableAfterDepartureSegment());
        }
        if (as.getExchangableBeforeDepartureSegment() != null) {
            segment.getPenaltiesInfo().setExchangableBeforeDeparture(as.getExchangableBeforeDepartureSegment());
        }
        if (as.getExchangableAfterDepartureSegment() != null) {
            segment.getPenaltiesInfo().setExchangableAfterDeparture(as.getExchangableAfterDepartureSegment());
        }
        if (as.getRefundBeforeDepartureSegment() != null) {
            segment.getPenaltiesInfo().setRefundBeforeDeparture(as.getRefundBeforeDepartureSegment());
        }
        if (as.getRefundAfterDepartureSegment() != null) {
            segment.getPenaltiesInfo().setRefundAfterDeparture(as.getRefundAfterDepartureSegment());
        }
        if (as.getExchangeBeforeDepartureSegment() != null) {
            segment.getPenaltiesInfo().setExchangeBeforeDeparture(as.getExchangeBeforeDepartureSegment());
        }
        if (as.getExchangeAfterDepartureSegment() != null) {
            segment.getPenaltiesInfo().setExchangeAfterDeparture(as.getExchangeAfterDepartureSegment());
        }
        if (as.getDisplayName() != null) {
            L10nStringHelper.copy((L10nString)as.getDisplayName(), (L10nString)segment.getFareDetails().getDisplayBrandName());
        }
    }

    static class PenaltiesInfoComparator
    implements Comparator<PenaltiesInfo> {
        private Product product;

        PenaltiesInfoComparator(Product product) {
            this.product = product;
        }

        @Override
        public int compare(PenaltiesInfo p1, PenaltiesInfo p2) {
            if (p1 == null) {
                return p2 == null ? 0 : -1;
            }
            if (p2 == null) {
                return 1;
            }
            int res = this.getRefundableExchangableIndex(p1.getRefundableBeforeDeparture()) - this.getRefundableExchangableIndex(p2.getRefundableBeforeDeparture());
            if (res != 0) {
                return res;
            }
            res = this.getRefundExchangeSubSum(this.product, p2.getRefundBeforeDeparture(), p2.getRefundBeforeDepartureFarePercent()).compareTo(this.getRefundExchangeSubSum(this.product, p1.getRefundBeforeDeparture(), p1.getRefundBeforeDepartureFarePercent()));
            if (res != 0) {
                return res;
            }
            res = this.getRefundableExchangableIndex(p1.getRefundableAfterDeparture()) - this.getRefundableExchangableIndex(p2.getRefundableAfterDeparture());
            if (res != 0) {
                return res;
            }
            res = this.getRefundExchangeSubSum(this.product, p2.getRefundAfterDeparture(), p2.getRefundAfterDepartureFarePercent()).compareTo(this.getRefundExchangeSubSum(this.product, p1.getRefundAfterDeparture(), p1.getRefundAfterDepartureFarePercent()));
            if (res != 0) {
                return res;
            }
            res = this.getRefundableExchangableIndex(p1.getExchangableBeforeDeparture()) - this.getRefundableExchangableIndex(p2.getExchangableBeforeDeparture());
            if (res != 0) {
                return res;
            }
            res = this.getRefundExchangeSubSum(this.product, p2.getExchangeBeforeDeparture(), p2.getExchangeBeforeDepartureFarePercent()).compareTo(this.getRefundExchangeSubSum(this.product, p1.getExchangeBeforeDeparture(), p1.getExchangeAfterDepartureFarePercent()));
            if (res != 0) {
                return res;
            }
            res = this.getRefundableExchangableIndex(p1.getExchangableAfterDeparture()) - this.getRefundableExchangableIndex(p2.getExchangableAfterDeparture());
            if (res != 0) {
                return res;
            }
            res = this.getRefundExchangeSubSum(this.product, p2.getExchangeAfterDeparture(), p2.getExchangeAfterDepartureFarePercent()).compareTo(this.getRefundExchangeSubSum(this.product, p1.getExchangeAfterDeparture(), p1.getExchangeAfterDepartureFarePercent()));
            if (res != 0) {
                return res;
            }
            return 0;
        }

        private BigDecimal getRefundExchangeSubSum(Product product, Money refundBeforeDeparture, Integer refundAfterDepartureFarePercent) {
            return PenaltiesInfoHelper.getProductEquivalentSum((Product)product, (Integer)refundAfterDepartureFarePercent, (Money)refundBeforeDeparture);
        }

        private int getRefundableExchangableIndex(Boolean val) {
            if (!Boolean.TRUE.equals(val)) {
                return 0;
            }
            return 1;
        }

        private DictionaryReference<PassengerType> getMostExpensivePassengerType(Flight flight) {
            DictionaryReference result = null;
            BigDecimal mostExpensiveFare = null;
            for (FlightFare fare : flight.getFares()) {
                BigDecimal ef = MiscUtil.guarded((BigDecimal)fare.getEquivalentAmount());
                if (result != null && ef.compareTo(mostExpensiveFare) <= 0) continue;
                result = fare.getPassengerType();
                mostExpensiveFare = MiscUtil.guarded((BigDecimal)ef);
            }
            return result;
        }
    }
}

