/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.airline;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.PenaltiesInfoHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CommonAirlineFlightVirtualizationAdvice
extends BaseAdvice {
    static final String VIRTUALIZED_FLIGHTS_KEY = CommonAirlineFlightVirtualizationAdvice.class.getName() + ".virtualizedFlights";

    public void before(MessageContext ctx) throws Exception {
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        ArrayList<VirtualizedFlight> vFlights = new ArrayList<VirtualizedFlight>();
        ctx.putObject(VIRTUALIZED_FLIGHTS_KEY, vFlights);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces() && builder != null;
        for (Flight flight : flights) {
            if (isSaveRulesTraces) {
                for (DictionaryReference pt : FlightHelper.collectPts((Flight)flight)) {
                    if (flight.getPenaltiesInfos().get(pt) == null) continue;
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("initial penalties info for %s is \n%s", pt, XSUtil.toString((XSSerializable)((XSSerializable)flight.getPenaltiesInfos().get(pt)))));
                }
            }
            if (flight.getSegmentTariffs().size() == 1 && ((FlightSegmentTariff)flight.getSegmentTariffs().get(0)).getSegments().size() == 1) continue;
            vFlights.add(new VirtualizedFlight(flight));
        }
        for (VirtualizedFlight vFlight : vFlights) {
            flights.addAll(vFlight.getVirtualSegmentFlights());
            flights.addAll(vFlight.getVirtualSegmentTariffFlights());
        }
    }

    public void after(MessageContext ctx) throws Exception {
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Collection vFlights = (Collection)ctx.removeObject(VIRTUALIZED_FLIGHTS_KEY);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces() && builder != null;
        for (VirtualizedFlight vFlight : vFlights) {
            Object fst2;
            Flight realFlight = vFlight.getRealFlight();
            int n = 0;
            for (Object fst2 : realFlight.getSegmentTariffs()) {
                block2: for (FlightSegment fs : fst2.getSegments()) {
                    ++n;
                    for (Flight vsf : vFlight.getVirtualSegmentFlights()) {
                        for (FlightSegmentTariff vfst : vsf.getSegmentTariffs()) {
                            for (FlightSegment vfs : vfst.getSegments()) {
                                if (!vfs.equals((Object)fs)) continue;
                                fs.getFareInfos().clear();
                                fs.getFareInfos().addAll(XCloneHelper.cloneCollection((Collection)vfs.getFareInfos(), (boolean)false, new HashMap()));
                                if (!isSaveRulesTraces) continue block2;
                                String vfInfo = builder.buildVariantInfo((BaseEntity)vsf);
                                builder.traceFlightLogic((BaseEntity)vFlight.getRealFlight(), MessageType.MESSAGE, String.format("Info for flight segment %s:\n%s", Integer.toString(n), vfInfo));
                                continue block2;
                            }
                        }
                    }
                }
            }
            n = 0;
            ArrayList<Map> infos = new ArrayList<Map>();
            fst2 = realFlight.getSegmentTariffs().iterator();
            block6: while (fst2.hasNext()) {
                String vfInfo;
                FlightSegmentTariff fst3 = (FlightSegmentTariff)fst2.next();
                ++n;
                for (Flight vf : vFlight.getVirtualSegmentTariffFlights()) {
                    if (!fst3.equals(vf.getSegmentTariffs().get(0)) || vf.getPenaltiesInfos() == null) continue;
                    infos.add(vf.getPenaltiesInfos());
                    if (!isSaveRulesTraces) continue block6;
                    vfInfo = builder.buildVariantInfo((BaseEntity)vf);
                    builder.traceFlightLogic((BaseEntity)vFlight.getRealFlight(), MessageType.MESSAGE, String.format("Info for flight segment tariff %s:\n%s", Integer.toString(n), vfInfo));
                    continue block6;
                }
                for (Flight vf : vFlight.getVirtualSegmentFlights()) {
                    if (!fst3.equals(vf.getSegmentTariffs().get(0)) || vf.getPenaltiesInfos() == null) continue;
                    infos.add(vf.getPenaltiesInfos());
                    if (!isSaveRulesTraces) continue block6;
                    vfInfo = builder.buildVariantInfo((BaseEntity)vf);
                    builder.traceFlightLogic((BaseEntity)vFlight.getRealFlight(), MessageType.MESSAGE, String.format("Info for flight segment tariff %s:\n%s", Integer.toString(n), vfInfo));
                    continue block6;
                }
            }
            ArrayList infos2 = new ArrayList(infos);
            Collections.sort(infos2, new PenaltiesInfoComparator(vFlight.getRealFlight()));
            Map stricktestInfo = (Map)infos2.get(0);
            if (isSaveRulesTraces) {
                builder.traceFlightLogic((BaseEntity)vFlight.getRealFlight(), MessageType.MESSAGE, String.format("Strictest info is %s", Integer.toString(infos.indexOf(stricktestInfo) + 1)));
            }
            vFlight.getRealFlight().getPenaltiesInfos().clear();
            vFlight.getRealFlight().getPenaltiesInfos().putAll(stricktestInfo);
            flights.removeAll(vFlight.getVirtualSegmentFlights());
            flights.removeAll(vFlight.getVirtualSegmentTariffFlights());
            if (builder == null) continue;
            for (Flight item : vFlight.getVirtualSegmentFlights()) {
                builder.removeVariant((BaseEntity)item);
            }
            for (Flight item : vFlight.getVirtualSegmentTariffFlights()) {
                builder.removeVariant((BaseEntity)item);
            }
        }
    }

    public static class VirtualizedFlight {
        private final Flight realFlight;
        private final List<Flight> virtualSegmentFlights;
        private final List<Flight> virtualSegmentTariffFlights;

        public VirtualizedFlight(Flight flight) throws Exception {
            this.realFlight = flight;
            this.virtualSegmentFlights = new ArrayList<Flight>(flight.getSegmentTariffs().size());
            this.virtualSegmentTariffFlights = new ArrayList<Flight>(flight.getSegmentTariffs().size());
            for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
                if (fst.getSegments().size() > 1) {
                    Flight virtualFlight = (Flight)XCloneHelper.clone((XCloneable)flight, (boolean)false);
                    virtualFlight.setUid(UUIDUtil.toString((UUID)UUID.randomUUID()));
                    virtualFlight.getSegmentTariffs().clear();
                    virtualFlight.getSegmentTariffs().add(XCloneHelper.clone((XCloneable)fst));
                    this.virtualSegmentTariffFlights.add(virtualFlight);
                }
                for (FlightSegment fs : fst.getSegments()) {
                    Flight virtualFlight = (Flight)XCloneHelper.clone((XCloneable)flight, (boolean)false);
                    virtualFlight.setUid(UUIDUtil.toString((UUID)UUID.randomUUID()));
                    virtualFlight.getSegmentTariffs().clear();
                    FlightSegmentTariff vfst = (FlightSegmentTariff)XCloneHelper.clone((XCloneable)fst);
                    virtualFlight.getSegmentTariffs().add(vfst);
                    vfst.getSegments().clear();
                    vfst.getSegments().add(XCloneHelper.clone((XCloneable)fs));
                    this.virtualSegmentFlights.add(virtualFlight);
                }
            }
        }

        public Flight getRealFlight() {
            return this.realFlight;
        }

        public List<Flight> getVirtualSegmentFlights() {
            return this.virtualSegmentFlights;
        }

        public List<Flight> getVirtualSegmentTariffFlights() {
            return this.virtualSegmentTariffFlights;
        }
    }

    static class PenaltiesInfoComparator
    implements Comparator<Map<DictionaryReference<PassengerType>, PenaltiesInfo>> {
        private Flight flight;

        PenaltiesInfoComparator(Flight flight) {
            this.flight = flight;
        }

        @Override
        public int compare(Map<DictionaryReference<PassengerType>, PenaltiesInfo> m1, Map<DictionaryReference<PassengerType>, PenaltiesInfo> m2) {
            DictionaryReference<PassengerType> mostExpensivePassengerType = this.getMostExpensivePassengerType(this.flight);
            if (mostExpensivePassengerType == null) {
                return 0;
            }
            PenaltiesInfo p1 = m1.get(mostExpensivePassengerType);
            PenaltiesInfo p2 = m2.get(mostExpensivePassengerType);
            if (p1 == null) {
                return p2 == null ? 0 : -1;
            }
            if (p2 == null) {
                return 1;
            }
            int res = this.getRefundableExchangableIndex(p1.getRefundableBeforeDeparture()) - this.getRefundableExchangableIndex(p2.getRefundableBeforeDeparture());
            if (res != 0) {
                return res;
            }
            res = this.getRefundExchangeSubSum(this.flight, mostExpensivePassengerType, p2.getRefundBeforeDeparture(), p2.getRefundBeforeDepartureFarePercent()).compareTo(this.getRefundExchangeSubSum(this.flight, mostExpensivePassengerType, p1.getRefundBeforeDeparture(), p1.getRefundBeforeDepartureFarePercent()));
            if (res != 0) {
                return res;
            }
            res = this.getRefundableExchangableIndex(p1.getRefundableAfterDeparture()) - this.getRefundableExchangableIndex(p2.getRefundableAfterDeparture());
            if (res != 0) {
                return res;
            }
            res = this.getRefundExchangeSubSum(this.flight, mostExpensivePassengerType, p2.getRefundAfterDeparture(), p2.getRefundAfterDepartureFarePercent()).compareTo(this.getRefundExchangeSubSum(this.flight, mostExpensivePassengerType, p1.getRefundAfterDeparture(), p1.getRefundAfterDepartureFarePercent()));
            if (res != 0) {
                return res;
            }
            res = this.getRefundableExchangableIndex(p1.getExchangableBeforeDeparture()) - this.getRefundableExchangableIndex(p2.getExchangableBeforeDeparture());
            if (res != 0) {
                return res;
            }
            res = this.getRefundExchangeSubSum(this.flight, mostExpensivePassengerType, p2.getExchangeBeforeDeparture(), p2.getExchangeBeforeDepartureFarePercent()).compareTo(this.getRefundExchangeSubSum(this.flight, mostExpensivePassengerType, p1.getExchangeBeforeDeparture(), p1.getExchangeAfterDepartureFarePercent()));
            if (res != 0) {
                return res;
            }
            res = this.getRefundableExchangableIndex(p1.getExchangableAfterDeparture()) - this.getRefundableExchangableIndex(p2.getExchangableAfterDeparture());
            if (res != 0) {
                return res;
            }
            res = this.getRefundExchangeSubSum(this.flight, mostExpensivePassengerType, p2.getExchangeAfterDeparture(), p2.getExchangeAfterDepartureFarePercent()).compareTo(this.getRefundExchangeSubSum(this.flight, mostExpensivePassengerType, p1.getExchangeAfterDeparture(), p1.getExchangeAfterDepartureFarePercent()));
            if (res != 0) {
                return res;
            }
            return 0;
        }

        private BigDecimal getRefundExchangeSubSum(Flight flight, DictionaryReference<PassengerType> mostExpensivePassengerType, Money refundBeforeDeparture, Integer refundAfterDepartureFarePercent) {
            return PenaltiesInfoHelper.getFlightEquivalentSum((Flight)flight, mostExpensivePassengerType, (Integer)refundAfterDepartureFarePercent, (Money)refundBeforeDeparture);
        }

        private int getRefundableExchangableIndex(Boolean val) {
            if (!Boolean.TRUE.equals(val)) {
                return 0;
            }
            return 1;
        }

        private DictionaryReference<PassengerType> getMostExpensivePassengerType(Flight flight) {
            DictionaryReference result = null;
            BigDecimal mostExpensiveFare = null;
            for (FlightFare fare : flight.getFares()) {
                BigDecimal ef = MiscUtil.guarded((BigDecimal)fare.getEquivalentAmount());
                if (result != null && ef.compareTo(mostExpensiveFare) <= 0) continue;
                result = fare.getPassengerType();
                mostExpensiveFare = MiscUtil.guarded((BigDecimal)ef);
            }
            return result;
        }
    }
}

