/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.airline;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineActionSet;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineTargets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.airline.CommonAirlineFlightVirtualizationAdvice;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonAirlineFlightsRuleProxyBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        ArrayList<RuleProxy> proxies = new ArrayList<RuleProxy>();
        Collection vFlights = (Collection)ctx.getObject(CommonAirlineFlightVirtualizationAdvice.VIRTUALIZED_FLIGHTS_KEY);
        HashMap<Flight, Flight> vFlightsMap = new HashMap<Flight, Flight>();
        for (CommonAirlineFlightVirtualizationAdvice.VirtualizedFlight vf : vFlights) {
            for (Flight virtFlight : vf.getVirtualSegmentFlights()) {
                vFlightsMap.put(virtFlight, vf.getRealFlight());
            }
            for (Flight virtFlight : vf.getVirtualSegmentTariffFlights()) {
                vFlightsMap.put(virtFlight, vf.getRealFlight());
            }
        }
        HashMap proxiesMap = new HashMap();
        for (Flight flight : flights) {
            ArrayList<RuleProxy> prxs = new ArrayList<RuleProxy>();
            proxiesMap.put(flight, prxs);
            for (DictionaryReference pt : FlightHelper.collectPts((Flight)flight)) {
                RuleProxy proxy = this.createProxy(flight, (DictionaryReference<PassengerType>)pt, salesContext, isSaveRulesTraces);
                proxies.add(proxy);
                prxs.add(proxy);
            }
        }
        for (Map.Entry entry : vFlightsMap.entrySet()) {
            List aProxies = (List)proxiesMap.get(entry.getKey());
            List aRealProxies = (List)proxiesMap.get(entry.getValue());
            for (RuleProxy proxy : aProxies) {
                RuleProxy realProxy = (RuleProxy)aRealProxies.get(0);
                ((FlightPropertySet)((Object)proxy.getPropertySet())).setTransportationType(((FlightPropertySet)((Object)realProxy.getPropertySet())).getTransportationType());
                ((FlightPropertySet)((Object)proxy.getPropertySet())).getDepartureLocations().clear();
                ((FlightPropertySet)((Object)proxy.getPropertySet())).getDepartureLocations().addAll(((FlightPropertySet)((Object)realProxy.getPropertySet())).getDepartureLocations());
                ((FlightPropertySet)((Object)proxy.getPropertySet())).setHasTransferTariffs(((FlightPropertySet)((Object)realProxy.getPropertySet())).isHasTransferTariffs());
            }
        }
        ctx.putObject((Enum)IBusGdsContextKeys.RULE_PROXIES, proxies);
    }

    protected RuleProxy<FlightPropertySet, CommonAirlineActionSet> createProxy(Flight flight, DictionaryReference<PassengerType> pt, SalesContext salesContext, boolean proxyTracerEnabled) {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(CommonAirlineTargets.AIRLINE_RULES.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)FlightPropertySet.create(flight, pt, PaymentType.INVOICE, null, proxy, salesContext));
        proxy.setActionSet((Object)new CommonAirlineActionSet());
        return proxy;
    }
}

