/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.airline;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineActionSet;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineTargets;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.GdsProductPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.EntityOperationTracingPartBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CommonAirlineReservationRuleProxyBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        EntityOperationTracingPartBuilder builder = (EntityOperationTracingPartBuilder)ctx.getObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_PART_BUILDER);
        ArrayList<RuleProxy<GdsProductPropertySet, CommonAirlineActionSet>> proxies = new ArrayList<RuleProxy<GdsProductPropertySet, CommonAirlineActionSet>>();
        List<Product> products = GDSHelper.getProducts(reservation);
        products.removeIf(it -> it.getNextProduct() != null);
        Boolean forcedRuleApplication = (Boolean)ctx.getObject((Enum)IBusBookingContextKeys.FORCED_RULES_APPLICATION);
        Map contractRulesAppliedInfo = (Map)ctx.getObject((Enum)IBusBookingContextKeys.APPLIED_CONTRACT_INFO);
        if (forcedRuleApplication != null && contractRulesAppliedInfo != null) {
            products.removeIf(it -> ProductStatusHandler.getAllVoidStatuses().contains(it.getStatus()) || GeneralProductHelper.isChecked((BaseProduct)it) || !Boolean.TRUE.equals(forcedRuleApplication) && Boolean.TRUE.equals(contractRulesAppliedInfo.get(it)));
        }
        for (Product prod : products) {
            RuleProxy<GdsProductPropertySet, CommonAirlineActionSet> realProxy = this.createProxy(prod, isSaveRulesTraces);
            proxies.add(realProxy);
            if (builder != null && prod.getPenaltiesInfo() != null) {
                builder.traceLogic(String.format("\nInitial penalties info of product %s is \n%s", AirProductHelper.getProductTitle((Product)prod), XSUtil.toString((XSSerializable)prod.getPenaltiesInfo())));
            }
            if (prod.getSegmentTariffs().size() == 1 && ((SegmentTariff)prod.getSegmentTariffs().get(0)).getSegments().size() == 1) continue;
            for (SegmentTariff st : prod.getSegmentTariffs()) {
                for (Segment seg : st.getSegments()) {
                    Product virtualProduct = this.cloneProduct(prod);
                    virtualProduct.setUid(String.format("virtual-seg-%s||%s", prod.getUid(), seg.getUid()));
                    virtualProduct.getSegmentTariffs().clear();
                    virtualProduct.getSegmentTariffs().add(XCloneHelper.clone((XCloneable)st, (boolean)true));
                    ((SegmentTariff)virtualProduct.getSegmentTariffs().get(0)).getSegments().clear();
                    ((SegmentTariff)virtualProduct.getSegmentTariffs().get(0)).getSegments().add(seg);
                    this.addProxy(proxies, virtualProduct, realProxy, isSaveRulesTraces);
                }
            }
            for (SegmentTariff st : prod.getSegmentTariffs()) {
                Product virtualProduct = this.cloneProduct(prod);
                virtualProduct.setUid(String.format("virtual-st-%s||%s", prod.getUid(), st.getUid()));
                virtualProduct.getSegmentTariffs().clear();
                virtualProduct.getSegmentTariffs().add(XCloneHelper.clone((XCloneable)st, (boolean)false));
                this.addProxy(proxies, virtualProduct, realProxy, isSaveRulesTraces);
            }
        }
        ctx.putObject((Enum)IBusGdsContextKeys.RULE_PROXIES, proxies);
    }

    private void addProxy(List<RuleProxy<GdsProductPropertySet, CommonAirlineActionSet>> proxies, Product virtualProduct, RuleProxy<GdsProductPropertySet, CommonAirlineActionSet> realProxy, boolean isSaveRulesTraces) throws Exception {
        RuleProxy<GdsProductPropertySet, CommonAirlineActionSet> proxy = this.createProxy(virtualProduct, isSaveRulesTraces);
        proxies.add(proxy);
        ((GdsProductPropertySet)((Object)proxy.getPropertySet())).setTransportationType(((GdsProductPropertySet)((Object)realProxy.getPropertySet())).getTransportationType());
        ((GdsProductPropertySet)((Object)proxy.getPropertySet())).getDepartureLocations().clear();
        ((GdsProductPropertySet)((Object)proxy.getPropertySet())).getDepartureLocations().addAll(((GdsProductPropertySet)((Object)realProxy.getPropertySet())).getDepartureLocations());
        ((GdsProductPropertySet)((Object)proxy.getPropertySet())).setHasTransferTariffs(((GdsProductPropertySet)((Object)realProxy.getPropertySet())).isHasTransferTariffs());
    }

    private Product cloneProduct(Product source) throws Exception {
        Product target = new Product();
        Product sourcePrevProduct = source.getPreviousProduct();
        Product sourceNextProduct = source.getNextProduct();
        Product targetPrevProduct = target.getPreviousProduct();
        Product targetNextProduct = target.getNextProduct();
        List targetRelatedProducts = target.getRelatedProducts();
        source.setPreviousProduct(null);
        source.setNextProduct(null);
        Reservation reservation = source.getReservation();
        Traveller traveller = source.getTraveller();
        source.setReservation(null);
        source.setTraveller(null);
        ArrayList relatedProducts = new ArrayList();
        relatedProducts.addAll(source.getRelatedProducts());
        source.getRelatedProducts().clear();
        XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        source.getRelatedProducts().addAll(relatedProducts);
        target.setReservation(reservation);
        source.setReservation(reservation);
        target.setTraveller(traveller);
        source.setTraveller(traveller);
        source.setPreviousProduct(sourcePrevProduct);
        source.setNextProduct(sourceNextProduct);
        target.setNextProduct(targetNextProduct);
        target.setPreviousProduct(targetPrevProduct);
        target.getRelatedProducts().clear();
        target.getRelatedProducts().addAll(targetRelatedProducts);
        return target;
    }

    private RuleProxy<GdsProductPropertySet, CommonAirlineActionSet> createProxy(Product product, boolean proxyTracerEnabled) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(CommonAirlineTargets.AIRLINE_RULES.getId());
        proxy.setProxyDate(new Date());
        GdsProductPropertySet ps = new GdsProductPropertySet(proxy);
        ps.init(product);
        proxy.setPropertySet((Object)ps);
        proxy.setActionSet((Object)new CommonAirlineActionSet());
        return proxy;
    }
}

