/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.airline;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.rules.airline.BrandedFaresActions;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.airline.TestCommonAirlineSettingsBuilder;
import com.gridnine.xtrip.server.gds.test.GDSTestBase;
import com.gridnine.xtrip.server.gds.test.TestFlightBuilder;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class CommonAirlineSettingsSegmentTariffTest
extends GDSTestBase {
    @Test
    public void testFlight() throws Exception {
        new TestCommonAirlineSettingsBuilder().airlineRule().restriction((RuleProperty)Properties.ROUTE, (RuleCondition)Conditions.CONFINED_TO, "RU-FRA").ruleResult((RuleAction)BrandedFaresActions.BRAND_NAME, "TEST").end().create();
        Flight flight = new TestFlightBuilder().fare(100.0, DictHelper.getAdultPassengerType()).segmentTariff().segment().fareInfo(DictHelper.getAdultPassengerType(), "xxx").airline("SU").locationBegin("LED").locationEnd("DME").end().segment().fareInfo(DictHelper.getAdultPassengerType(), "xxx").airline("SU").locationBegin("DME").locationEnd("FRA").end().end().segmentTariff().segment().fareInfo(DictHelper.getAdultPassengerType(), "xxx").airline("SU").locationBegin("FRA").locationEnd("DME").end().end().getEntity();
        HashMap data = new HashMap();
        ArrayList<Flight> flights = new ArrayList<Flight>();
        flights.add(flight);
        data.put(IBusGdsContextKeys.FLIGHTS.name(), flights);
        data.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), new SalesContext());
        IntegrationBusFacade.get().processRouteSync("gds:apply-branded-fare-rules-to-flight", data);
        for (FlightSegmentTariff st : ((Flight)flights.get(0)).getSegmentTariffs()) {
            for (FlightSegment segment : st.getSegments()) {
                Assert.assertEquals((Object)"TEST", (Object)L10nStringHelper.getValue((L10nString)((FareInfo)segment.getFareInfos().get(0)).getFareDetails().getDisplayBrandName(), (Locale)LocaleHelper.EN_LOCALE, (boolean)false));
            }
        }
    }

    @Test
    public void testReservation() throws Exception {
        new TestCommonAirlineSettingsBuilder().airlineRule().restriction((RuleProperty)Properties.ROUTE, (RuleCondition)Conditions.CONFINED_TO, "RU-FRA").ruleResult((RuleAction)BrandedFaresActions.BRAND_NAME, "TEST").end().create();
        Reservation reservation = (Reservation)((BookingFile)new TestBookingFileBuilder().traveller().end().reservation().airProduct().segmentTariff().segment().departureLocation("LED").arriveLocation("DME").end().segment().departureLocation("DME").arriveLocation("FRA").end().end().segmentTariff().segment().departureLocation("FRA").arriveLocation("LED").end().end().vendorContractRelation().fop().end().end().clientContractRelation().fop().end().end().end().end().getEntity()).getReservations().get(0);
        HashMap<String, Reservation> data = new HashMap<String, Reservation>();
        data.put(IBusMidofficeContextKeys.RESERVATION.name(), reservation);
        IntegrationBusFacade.get().processRouteSync("gds:apply-branded-fare-rules-to-reservation", data);
        for (SegmentTariff st : ((Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0)).getSegmentTariffs()) {
            for (Segment segment : st.getSegments()) {
                Assert.assertEquals((Object)"TEST", (Object)L10nStringHelper.getValue((L10nString)segment.getFareDetails().getDisplayBrandName(), (Locale)LocaleHelper.EN_LOCALE, (boolean)false));
            }
        }
    }
}

