/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.airline;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineActionSet;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineRulesHelper;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineTargets;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.GdsProductPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;

public class GetFoidTypeToSendProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RuleSet rules = this.getRules(ctx);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean trace = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        CommonAirlineActionSet as = this.applyRules(rules, reservation, trace);
        ctx.putObject((Enum)IBusGdsContextKeys.FOID_TYPE_TO_SEND, (Object)as.getFoidTypeToSend());
    }

    protected RuleSet getRules(MessageContext ctx) throws Exception {
        return CommonAirlineRulesHelper.getCommonAirlineSettings().getRuleSet();
    }

    private CommonAirlineActionSet applyRules(RuleSet rules, Reservation reservation, boolean proxyTracerEnabled) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(CommonAirlineTargets.AIRLINE_RULES.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new GdsProductPropertySet(proxy));
        ((GdsProductPropertySet)((Object)proxy.getPropertySet())).init((Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0));
        proxy.setActionSet((Object)this.createActionSet());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return (CommonAirlineActionSet)proxy.getActionSet();
    }

    protected CommonAirlineActionSet createActionSet() {
        return new CommonAirlineActionSet();
    }
}

