/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.autorefund;

import com.gridnine.xtrip.common.gds.model.PenaltyBasis;
import com.gridnine.xtrip.common.gds.model.PenaltyProperties;
import com.gridnine.xtrip.common.gds.model.PenaltyTarget;
import com.gridnine.xtrip.common.gds.rules.AutoRefundActionsSet;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefundFinanceDetails;
import com.gridnine.xtrip.common.midoffice.model.UnsellProductFinanceDetailsDebugInfo;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.autorefund.AutoRefundHelper;
import com.gridnine.xtrip.server.gds.rules.proxy.GdsProductPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class AutoRefundCalculateGdsDetailsProcessor
extends BaseProcessor {
    static final String CURRENCY_RUB = "RUB";

    public void process(MessageContext ctx) throws Exception {
        List contracts = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AUTOREFUND_VENDOR_CONTRACTS);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        GdsProductRefundFinanceDetails details = AutoRefundHelper.getOrCreateRecord(product, AutoRefundHelper.getOrCreateMap(ctx));
        UnsellProductFinanceDetailsDebugInfo debugInfo = details.getDebugInfo();
        if (debugInfo.getDebugInfo() == null) {
            debugInfo.setDebugInfo(new DebugInfo());
        }
        debugInfo.getDebugInfo().startBlock("autorefund");
        this.fillRefundProductDetails(details, product, contracts, ctx);
        debugInfo.getDebugInfo().endBlock();
    }

    private boolean isProductValidForRefund(Product prod) {
        return prod.getStatus() == ProductStatus.SELL && prod.getNextProduct() == null;
    }

    private void fillRefundProductDetails(GdsProductRefundFinanceDetails details, Product prod, List<EntityContainer<Contract>> contracts, MessageContext ctx) {
        Map priceUnitParams = (Map)ctx.getObject((Enum)IBusGdsContextKeys.PASSENGER_TYPE_SEGMENT_TARIFF_COUNT_MAP);
        Integer priceUnitCount = null;
        if (priceUnitParams != null) {
            priceUnitCount = (Integer)priceUnitParams.get(prod.getPassengerType());
        }
        details.setEquivalentFare(null);
        details.setPenalty(null);
        details.setPossible(false);
        if (!this.isProductValidForRefund(prod)) {
            return;
        }
        try {
            AutoRefundActionsSet as = this.applyRulesForAutoRefund(prod, contracts, details.getDebugInfo(), ctx, priceUnitCount);
            if (!this.isAutoRefundAllowed(as)) {
                return;
            }
            List<Product> virtualProducts = this.generateVirtualProductFromSegments(prod, contracts, details);
            if (virtualProducts.size() > 0) {
                for (Product virtualProduct : virtualProducts) {
                    AutoRefundActionsSet was = this.applyRulesForAutoRefund(virtualProduct, contracts, details.getDebugInfo(), ctx, priceUnitCount);
                    if (this.isAutoRefundAllowed(was)) continue;
                    details.getDebugInfo().getDebugInfo().message(String.format("\u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0433\u043e \u0438\u0437 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u043e\u0432 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 %s \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d", prod.getSystemNumber()));
                    return;
                }
            }
            details.setPossible(true);
            HashMap<String, BigDecimal> taxesWithPenaltiesMap = new HashMap<String, BigDecimal>();
            BigDecimal farePenalty = BigDecimal.ZERO;
            BigDecimal penalty = BigDecimal.ZERO;
            for (RuleResultValue item : as.getPenalties()) {
                EntityContainer propCtr;
                if (item.getTarget() == null || !PenaltyProperties.class.equals((Object)item.getTarget().getType()) || (propCtr = EntityStorage.get().resolve(item.getTarget())) == null) continue;
                PenaltyProperties penaltyProperties = (PenaltyProperties)propCtr.getEntity();
                PenaltyTarget target = penaltyProperties.getTarget();
                if (target == null) {
                    target = penaltyProperties.getCalculationBasis() == PenaltyBasis.TARIFF || TextUtil.isBlank((String)((PenaltyProperties)propCtr.getEntity()).getFinanceCode()) ? PenaltyTarget.PENALTY : PenaltyTarget.TAXES;
                }
                BigDecimal penaltyAmount = this.calculatePenaltyAmount(item, prod, priceUnitCount);
                switch (target) {
                    case TARIFF: {
                        farePenalty = farePenalty.add(penaltyAmount);
                        break;
                    }
                    case PENALTY: {
                        penalty = penalty.add(penaltyAmount);
                        break;
                    }
                    case TAXES: {
                        String taxCode = penaltyProperties.getFinanceCode();
                        if (taxCode == null) {
                            details.getDebugInfo().getDebugInfo().warning(String.format("\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0448\u0442\u0440\u0430\u0444\u0430 %s \u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0435\u0442\u0441\u044f \u043d\u0430 \u0442\u0430\u043a\u0441\u044b \u043d\u043e \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043a\u043e\u0434 \u0442\u0430\u043a\u0441\u044b", penaltyProperties.getDisplayName()));
                            break;
                        }
                        taxesWithPenaltiesMap.put(taxCode, MiscUtil.guarded((BigDecimal)penaltyAmount));
                        break;
                    }
                }
            }
            BigDecimal ef = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)prod));
            if (penalty != null && penalty.compareTo(ef) > 0 && prod.getCarrier() != null && "SU".equals(prod.getCarrier().getCode())) {
                details.getDebugInfo().getDebugInfo().message(String.format("\u0448\u0442\u0440\u0430\u0444 %s \u043e\u043a\u0430\u0437\u0430\u043b\u0441\u044f \u0431\u043e\u043b\u044c\u0448\u0435 \u0442\u0430\u0440\u0438\u0444\u0430 %s, \u043f\u043e \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u043c \u0410\u044d\u0440\u043e\u0444\u043b\u043e\u0442\u0430 \u0437\u0430\u043d\u0443\u043b\u044f\u0435\u043c \u0442\u0430\u0440\u0438\u0444 \u0438 \u0442\u0430\u043a\u0441\u044b", penalty, ef));
                penalty = BigDecimal.ZERO;
                farePenalty = ef;
            }
            details.setPenalty(penalty);
            details.getDebugInfo().getDebugInfo().message(String.format("\u0448\u0442\u0440\u0430\u0444 \u0440\u0430\u0432\u0435\u043d %s", penalty));
            if (as.getFarePenaltyData() != null) {
                if (MiscUtil.isZero((BigDecimal)farePenalty, (boolean)true)) {
                    Money fareTaxPenalty = (Money)as.getFarePenaltyData().getFirst();
                    String farePenaltyTaxCode = (String)as.getFarePenaltyData().getSecond();
                    BigDecimal fareTaxPenaltyValue = fareTaxPenalty.getValue();
                    if (!CURRENCY_RUB.equals(fareTaxPenalty.getCurrency())) {
                        fareTaxPenaltyValue = FinanceHelper.calculateExchangePrice((BigDecimal)fareTaxPenaltyValue, (String)CURRENCY_RUB, (String)fareTaxPenalty.getCurrency(), (CurrencyRateType)CurrencyRateType.IATA, (TariffType)prod.getTariffType(), (Date)new Date(), (EntityReference)GeneralProductHelper.getSupplier((BaseProduct)prod), (boolean)false);
                        fareTaxPenaltyValue = RulesHelper.roundDouble((BigDecimal)fareTaxPenaltyValue, (RoundingMode)RoundingMode.MATH, (RoundingValue)RoundingValue.V_1);
                    }
                    if (fareTaxPenaltyValue.compareTo(ef) > 0) {
                        farePenalty = ef;
                        BigDecimal taxPenalty = (BigDecimal)taxesWithPenaltiesMap.get(farePenaltyTaxCode);
                        taxesWithPenaltiesMap.put(farePenaltyTaxCode, MiscUtil.sum((BigDecimal[])new BigDecimal[]{taxPenalty, fareTaxPenaltyValue.subtract(ef)}));
                    } else {
                        farePenalty = fareTaxPenaltyValue;
                    }
                } else {
                    details.getDebugInfo().getDebugInfo().message(String.format("\u0448\u0442\u0440\u0430\u0444 \u043d\u0430 \u0442\u0430\u0440\u0438\u0444+\u0442\u0430\u043a\u0441\u0443 \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u043e\u0438\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u043d, \u0442\u0430\u043a \u043a\u0430\u043a \u0431\u044b\u043b \u0443\u043a\u0437\u0430\u043d \u043e\u0431\u044b\u0447\u043d\u044b\u0439 \u0448\u0442\u0440\u0430\u0444 \u043d\u0430 \u0442\u0430\u0440\u0438\u0444", penalty));
                }
            }
            details.getDebugInfo().getDebugInfo().message(String.format("\u0443\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435 \u043f\u043e \u0442\u0430\u0440\u0438\u0444\u0443 \u0440\u0430\u0432\u043d\u043e %s", farePenalty));
            if (farePenalty.compareTo(BigDecimal.ZERO) != 0) {
                if (ef.compareTo(farePenalty) == 0) {
                    details.setEquivalentFare(BigDecimal.ZERO);
                    Money baseFareClone = (Money)XCloneHelper.clone((XCloneable)AirProductHelper.getBaseFare((Product)prod));
                    if (baseFareClone != null) {
                        baseFareClone.setValue(BigDecimal.ZERO);
                    }
                    details.setBaseFare(baseFareClone);
                    details.getDebugInfo().getDebugInfo().message("\u0442\u0430\u0440\u0438\u0444 \u043d\u0435\u0432\u043e\u0437\u0432\u0440\u0430\u0442\u043d\u044b\u0439");
                } else {
                    Object equiveCurrency;
                    Money baseFare = AirProductHelper.getBaseFare((Product)prod);
                    Object object = equiveCurrency = prod.getGdsCurrency() == null ? DictHelper.getEquivCurrency() : prod.getGdsCurrency();
                    if (baseFare != null && !((String)equiveCurrency).equals(baseFare.getCurrency())) {
                        throw Xeption.forEndUser((String)"\u043d\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u0443\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430 \u043f\u043e \u0447\u0430\u0441\u0442\u0438\u0447\u043d\u043e\u043c\u0443 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0443 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e, \u0435\u0441\u043b\u0438 \u0432\u0430\u043b\u044e\u0442\u0430 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0440\u0430\u0432\u043d\u0430 \u044d\u043a\u0432\u0438\u0432\u0430\u043b\u0435\u043d\u0442\u043d\u043e\u0439 \u0432\u0430\u043b\u044e\u0442\u0435", (Object[])new Object[0]);
                    }
                    details.setEquivalentFare(ef.subtract(farePenalty));
                    Money baseFareClone = (Money)XCloneHelper.clone((XCloneable)baseFare);
                    baseFareClone.setValue(details.getEquivalentFare());
                    details.setBaseFare(baseFareClone);
                    details.getDebugInfo().getDebugInfo().message(String.format("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0447\u0430\u0441\u0442\u0438\u0447\u043d\u044b\u0439, \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u043d\u044b\u0439 \u0442\u0430\u0440\u0438\u0444 \u0440\u0430\u0432\u0435\u043d %s", details.getEquivalentFare()));
                }
            } else {
                details.setEquivalentFare(MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)prod)));
                details.setBaseFare(AirProductHelper.getBaseFare((Product)prod));
            }
            LinkedHashMap<String, BigDecimal> originalTaxesAmountsMap = new LinkedHashMap<String, BigDecimal>();
            for (Tax tax : prod.getTaxes()) {
                if (tax.getCode() == null) {
                    details.getDebugInfo().getDebugInfo().warning(String.format("\u0432 \u0431\u0438\u043b\u0435\u0442\u0435 %s \u0435\u0441\u0442\u044c \u0442\u0430\u043a\u0441\u044b \u0431\u0435\u0437 \u043a\u043e\u0434\u0430", prod.getSystemNumber()));
                    continue;
                }
                originalTaxesAmountsMap.put(tax.getCode(), MiscUtil.sum((BigDecimal[])new BigDecimal[]{tax.getEquivalentAmount(), (BigDecimal)originalTaxesAmountsMap.get(tax.getCode())}));
            }
            BigDecimal returnedTaxesAmount = BigDecimal.ZERO;
            if (as.isNotRefundAllTaxes()) {
                details.getDebugInfo().getDebugInfo().message(String.format("\u0412\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u0443\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435 \u0432\u0441\u0435\u0445 \u0442\u0430\u043a\u0441", new Object[0]));
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : originalTaxesAmountsMap.entrySet()) {
                SimpleTax returnedTax = new SimpleTax();
                String taxCode = (String)entry.getKey();
                returnedTax.setCode(taxCode);
                BigDecimal returnedAmount = BigDecimal.ZERO;
                if (!as.isNotRefundAllTaxes()) {
                    BigDecimal taxPenalty = (BigDecimal)taxesWithPenaltiesMap.get(taxCode);
                    returnedAmount = ((BigDecimal)entry.getValue()).subtract(MiscUtil.guarded((BigDecimal)taxPenalty));
                }
                returnedTax.setAmount(returnedAmount);
                details.getTaxes().add(returnedTax);
                returnedTaxesAmount = returnedTaxesAmount.add(returnedAmount);
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(String.format("%s: %s", taxCode, returnedAmount));
            }
            details.getDebugInfo().getDebugInfo().message(String.format("\u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0440\u0430\u0432\u043d\u0430 %s: \u0442\u0430\u0440\u0438\u0444: %s, \u0448\u0442\u0440\u0430\u0444: %s, \u0442\u0430\u043a\u0441\u044b: %s", details.getEquivalentFare().subtract(details.getPenalty()).add(returnedTaxesAmount), details.getEquivalentFare(), details.getPenalty(), sb.toString()));
        }
        catch (Exception ex) {
            this.log.error("unable to calculate refunded sums", (Throwable)ex);
            details.setPossible(false);
            details.getDebugInfo().getDebugInfo().error("\u043f\u0440\u0438 \u043f\u043e\u0434\u0441\u0447\u0435\u0442\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)ex);
        }
    }

    private List<Product> generateVirtualProductFromSegments(Product realProduct, List<EntityContainer<Contract>> contracts, GdsProductRefundFinanceDetails details) throws Exception {
        List segments = realProduct.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).filter(Objects::nonNull).collect(Collectors.toList());
        if (segments.size() <= 1) {
            return Collections.emptyList();
        }
        ArrayList<Product> virtProducts = new ArrayList<Product>();
        for (Segment s : segments) {
            Product vProduct = new Product();
            AirProductHelper.copy((Product)realProduct, (Product)vProduct, (boolean)false);
            vProduct.getSegmentTariffs().clear();
            SegmentTariff st2 = new SegmentTariff();
            st2.getSegments().add(s);
            vProduct.getSegmentTariffs().add(st2);
            virtProducts.add(vProduct);
        }
        return virtProducts;
    }

    private RuleResultValue getRuleResult(AutoRefundActionsSet as, Product prod) {
        if (as.getPenalties().size() != 1) {
            return null;
        }
        return (RuleResultValue)as.getPenalties().iterator().next();
    }

    private boolean isAutoRefundAllowed(AutoRefundActionsSet as) {
        if (as == null) {
            return false;
        }
        return as.isAutoRefundAllowed();
    }

    private BigDecimal calculatePenaltyAmount(RuleResultValue rrv, Product product, Integer priceUnitCount) {
        EntityContainer prop;
        BigDecimal rrvValue = BigDecimal.ZERO;
        BigDecimal value = BigDecimal.valueOf(rrv.getValue());
        boolean isPercent = false;
        RoundingMode rm = null;
        RoundingValue rv = null;
        CalculationType ct = null;
        PenaltyBasis cb = null;
        String taxCode = null;
        if (rrv.getTarget() != null && (prop = EntityStorage.get().resolve(rrv.getTarget())) != null) {
            isPercent = ((PenaltyProperties)prop.getEntity()).isRate();
            rm = ((PenaltyProperties)prop.getEntity()).getRoundingMode();
            rv = ((PenaltyProperties)prop.getEntity()).getRoundingValue();
            ct = ((PenaltyProperties)prop.getEntity()).getCalculationType();
            cb = ((PenaltyProperties)prop.getEntity()).getCalculationBasis();
            taxCode = ((PenaltyProperties)prop.getEntity()).getFinanceCode();
        }
        if (isPercent != rrv.getCurrencyCode().equals("%")) {
            return BigDecimal.ZERO;
        }
        if (isPercent) {
            BigDecimal fare = BigDecimal.ZERO;
            if (cb == PenaltyBasis.TARIFF) {
                fare = AirProductHelper.getEquivalentFare((Product)product);
            } else if (cb == PenaltyBasis.TAXES) {
                fare = this.calcTaxesFare(product, taxCode);
            }
            rrvValue = fare.multiply(value).divide(BigDecimal.valueOf(100L));
        } else {
            Date date;
            rrvValue = value;
            if (ct == CalculationType.SEGMENT) {
                rrvValue = rrvValue.multiply(BigDecimal.valueOf(this.getProductSegmentCount(product)));
            }
            if (ct == CalculationType.SEGMENT_TARIFF) {
                rrvValue = rrvValue.multiply(BigDecimal.valueOf(priceUnitCount != null ? (long)priceUnitCount.intValue() : (long)this.getProductSegmentTariffCount(product)));
            }
            Date date2 = date = "S7".equals(DictHelper.getCodeVariant((DictionaryReference)product.getCarrier(), (CodeSystem[])new CodeSystem[]{CodeSystem.IATA})) ? product.getIssueDate() : new Date();
            if (!CURRENCY_RUB.equals(rrv.getCurrencyCode())) {
                rrvValue = FinanceHelper.calculateExchangePrice((BigDecimal)rrvValue, (String)CURRENCY_RUB, (String)rrv.getCurrencyCode(), (CurrencyRateType)CurrencyRateType.IATA, (TariffType)product.getTariffType(), (Date)date, (EntityReference)GeneralProductHelper.getSupplier((BaseProduct)product), (boolean)false);
            }
        }
        return RulesHelper.roundDouble((BigDecimal)rrvValue, (RoundingMode)rm, (RoundingValue)rv);
    }

    private BigDecimal calcTaxesFare(Product product, String code) {
        if (code == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = BigDecimal.ZERO;
        for (Tax tax : product.getTaxes()) {
            if (!code.equalsIgnoreCase(tax.getCode())) continue;
            result = result.add(tax.getEquivalentAmount());
        }
        return result;
    }

    private int getProductSegmentCount(Product p) {
        int result = 0;
        for (SegmentTariff st : p.getSegmentTariffs()) {
            result += st.getSegments().size();
        }
        return result;
    }

    private int getProductSegmentTariffCount(Product p) {
        return p.getSegmentTariffs().size();
    }

    private AutoRefundActionsSet applyRulesForAutoRefund(Product product, List<EntityContainer<Contract>> contracts, UnsellProductFinanceDetailsDebugInfo debugInfo, MessageContext ctx, Integer priceUnitCount) throws Exception {
        ContractType contractType = ContractType.VENDOR;
        if (contracts.isEmpty()) {
            this.log.debug(String.format("no contracts of type \"%s\" were collected", contractType.name()));
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_MISSING_CONTRACT_OF_TYPE, (Object[])new Object[]{contractType}));
            return null;
        }
        AutoRefundActionsSet autoRefundActionsSet = new AutoRefundActionsSet();
        DebugInfo info = null;
        RuleProxy proxy = new RuleProxy();
        for (EntityContainer<Contract> contractCtr : contracts) {
            HashSet beforeRules = new HashSet(proxy.getAppliedRules());
            List rules = ProfileHelper.getRuleContainers(contractCtr, (Date)new Date());
            proxy.getTracer().setDisabled(info != null);
            proxy.setProxyType(Targets.REFUND_PARAMETERS.getId());
            proxy.setProxyDate(new Date());
            proxy.setPropertySet((Object)new GdsProductPropertySet(proxy));
            if (info == null) {
                info = new DebugInfo();
                proxy.getTracer().setDebugInfo(info);
            }
            ((GdsProductPropertySet)((Object)proxy.getPropertySet())).init(product);
            if (priceUnitCount != null) {
                ((GdsProductPropertySet)((Object)proxy.getPropertySet())).setNumOfSegmentTariffs(priceUnitCount);
            }
            proxy.setActionSet((Object)autoRefundActionsSet);
            for (EntityContainer container : rules) {
                RuleSet ruleSet = ProfileHelper.getRuleSet((EntityContainer)container);
                RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)ruleSet);
            }
            HashSet localRules = new HashSet(proxy.getAppliedRules());
            localRules.removeAll(beforeRules);
            List appliedRules = RulesHelper.calcAppliedRulesToBooking((RuleProxy)proxy, localRules, (List)rules, (BaseProduct)product, contractCtr);
            debugInfo.getAppliedRules().addAll(appliedRules);
            for (AppliedRule rule : appliedRules) {
                info.message(String.format("\u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043e \u043f\u0440\u0430\u0432\u0438\u043b\u043e %s \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 %s", rule.getRuleName(), ((Contract)contractCtr.getEntity()).toString()));
            }
            if (appliedRules.isEmpty()) continue;
            info.message("appliedRules.addAll: " + ctx.getRouteDump());
        }
        if (info != null) {
            debugInfo.getDebugInfo().addBlock(info);
        }
        return autoRefundActionsSet;
    }
}

