/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.autorefund;

import com.gridnine.xtrip.common.midoffice.model.GdsProductRefundFinanceDetails;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.rules.AirRulesHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class AutoRefundHelper {
    private AutoRefundHelper() {
    }

    public static List<Product> extractRefundableProducts(Reservation res) {
        ArrayList<Product> appropriateProducts = new ArrayList<Product>();
        for (Product product : GDSHelper.getProducts(res)) {
            if (product.getStatus() != ProductStatus.SELL) continue;
            appropriateProducts.add(product);
        }
        return appropriateProducts;
    }

    public static List<Product> extractRefundableProducts(Reservation res, ProductCategory ... categories) {
        ArrayList<Product> appropriateProducts = new ArrayList<Product>();
        for (Product product : GDSHelper.getProducts(res, categories)) {
            if (product.getStatus() != ProductStatus.SELL) continue;
            appropriateProducts.add(product);
        }
        return appropriateProducts;
    }

    public static List<EntityContainer<Contract>> getVendorContractContainers(Product product) throws Exception {
        EntityReference supplier = AirProductHelper.getSupplier((Product)product);
        EntityReference agency = AirProductHelper.getAgency((Product)product);
        EntityReference blankOwner = product.getBlankOwnerRef();
        EntityContainer contract = EntityStorage.get().resolve(GeneralProductHelper.getVendorContractRelation((BaseProduct)product).getGeneralData().getContractData().getManualContract());
        if (null == contract) {
            contract = AirRulesHelper.getContract((ContractType)ContractType.VENDOR, (Product)product, (EntityReference)blankOwner, (EntityReference)supplier, (EntityReference)agency);
        }
        if (contract != null) {
            return Collections.singletonList(contract);
        }
        MiscUtil.Pair collectContracts = AirRulesHelper.collectOldContracts((ContractType)ContractType.VENDOR, (Product)product, (EntityReference)blankOwner, (EntityReference)supplier, (EntityReference)agency, (Date)new Date());
        return (List)collectContracts.getFirst();
    }

    public static GdsProductRefundFinanceDetails getOrCreateRecord(Product product, Map<String, GdsProductRefundFinanceDetails> map) {
        GdsProductRefundFinanceDetails record = map.get(product.getUid());
        if (record == null) {
            record = new GdsProductRefundFinanceDetails();
            map.put(product.getUid(), record);
        }
        return record;
    }

    public static Map<String, GdsProductRefundFinanceDetails> getOrCreateMap(MessageContext ctx) {
        HashMap map = (HashMap)ctx.getObject((Enum)IBusGdsContextKeys.AUTOREFUND_GDS_DETAILS);
        if (map == null) {
            map = new HashMap();
            ctx.putObject((Enum)IBusGdsContextKeys.AUTOREFUND_GDS_DETAILS, map);
        }
        return map;
    }

    public static boolean isOnlyMcoRefund(Reservation reservation, Map<String, ProductStatus> request) {
        Set mcoUids = AirProductHelper.getProducts((Reservation)reservation).stream().filter(p -> p.getProductCategory() == ProductCategory.MCO).map(BaseIdentity::getUid).collect(Collectors.toSet());
        return mcoUids.containsAll(request.entrySet().stream().filter(e -> e.getValue() == ProductStatus.REFUND).map(Map.Entry::getKey).collect(Collectors.toSet()));
    }
}

