/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.autorefund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefundFinanceDetails;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.autorefund.AutoRefundHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.Map;

public class AutoRefundImppossibleProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map refexRequest = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST);
        ctx.putObject((Enum)IBusGdsContextKeys.AUTOREFUND_GDS_DETAILS, this.composeRefundDataMap(res, refexRequest));
    }

    private Map<String, GdsProductRefundFinanceDetails> composeRefundDataMap(Reservation res, Map<String, ProductStatus> refexRequest) {
        HashMap<String, GdsProductRefundFinanceDetails> result = new HashMap<String, GdsProductRefundFinanceDetails>();
        for (BaseProduct baseProduct : AutoRefundHelper.extractRefundableProducts(res)) {
            if (refexRequest.get(baseProduct.getUid()) != ProductStatus.REFUND) continue;
            GdsProductRefundFinanceDetails gdsData = new GdsProductRefundFinanceDetails();
            gdsData.setPossible(true);
            result.put(baseProduct.getUid(), gdsData);
        }
        return result;
    }
}

