/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.autorefund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.server.gds.ibus.autorefund.AutoRefundHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AutoRefundPutProductsOfCategoriesProcessor
extends BaseProcessor {
    ProductCategory[] categories;

    public void configure(Map<String, String> parameters) {
        this.categories = (ProductCategory[])Arrays.stream(parameters.get("categories").split(",")).map(ProductCategory::valueOf).toArray(ProductCategory[]::new);
    }

    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map refexRequest = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST);
        ArrayList<Product> result = new ArrayList<Product>();
        List<Product> prods = AutoRefundHelper.extractRefundableProducts(reservation, this.categories);
        for (Product product : prods) {
            if (refexRequest.get(product.getUid()) != ProductStatus.REFUND) continue;
            result.add(product);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS, result);
    }
}

