/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.autorefund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.TimeService;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineActionSet;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineTargets;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefundFinanceDetails;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.PccParameter;
import com.gridnine.xtrip.common.model.profile.PccParameterName;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.autorefund.AutoRefundHelper;
import com.gridnine.xtrip.server.gds.rules.proxy.GdsProductPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class AutoUnsellAnalyzerAviaProductsProcessor
extends BaseProcessor {
    private final List<String> validTimeZoneCodes = Arrays.asList(TimeZone.getAvailableIDs());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageContext ctx) throws Exception {
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ArrayList<Product> appropriateProducts = new ArrayList<Product>();
        Map refexRequest = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST);
        for (Product prod : AutoRefundHelper.extractRefundableProducts(res, ProductCategory.AIR, ProductCategory.MCO)) {
            if (refexRequest.get(prod.getUid()) != ProductStatus.REFUND) continue;
            appropriateProducts.add(prod);
        }
        Map<String, GdsProductRefundFinanceDetails> detailsMap = AutoRefundHelper.getOrCreateMap(ctx);
        String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)res);
        if (appropriateProducts.isEmpty()) {
            ctx.putObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE, (Object)Boolean.FALSE);
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u043d\u0435\u0442 \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", (Object[])new Object[]{recordLocator}));
            ctx.putObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE, (Object)Boolean.FALSE);
            return;
        }
        boolean voidAllowed = true;
        boolean refundAllowed = true;
        for (Product prod : appropriateProducts) {
            GdsProductRefundFinanceDetails productDetails = AutoRefundHelper.getOrCreateRecord(prod, detailsMap);
            productDetails.getDebugInfo().setProductUid(prod.getUid());
            if (productDetails.getDebugInfo().getDebugInfo() == null) {
                productDetails.getDebugInfo().setDebugInfo(new DebugInfo());
            }
            productDetails.getDebugInfo().getDebugInfo().startBlock("autovoid");
            try {
                Message message;
                productDetails.getDebugInfo().getDebugInfo().message(String.format("\u0430\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u0435\u043c \u043f\u0440\u043e\u0434\u0443\u043a\u0442 %s", prod.getSystemNumber()));
                if (prod.getIssueDate() == null) {
                    Message msg = SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u0430\u0432\u0438\u0430 \u0443\u0441\u043b\u0443\u0433\u0435 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438", (Object[])new Object[]{prod.getSystemNumber()});
                    ctx.addMessage(msg);
                    productDetails.getDebugInfo().getDebugInfo().message(msg.getMessage().toString());
                    ctx.putObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE, (Object)Boolean.FALSE);
                    return;
                }
                RuleSet ruleSet = (RuleSet)ctx.getObject((Enum)IBusGdsContextKeys.RULES);
                CommonAirlineActionSet actionSet = this.calcActionSet(prod, productDetails, ruleSet);
                if (!this.isTicketIssuedToday(prod, ctx)) {
                    Message msg = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0434\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438 \u0432 \u0430\u0432\u0438\u0430 \u0443\u0441\u043b\u0443\u0433\u0435 {0} \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0430\u0442\u043e\u0439, \u0430\u0432\u0442\u043e\u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e", (Object[])new Object[]{prod.getSystemNumber()});
                    ctx.addMessage(msg);
                    voidAllowed = false;
                    ctx.putObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE, (Object)Boolean.FALSE);
                    productDetails.getDebugInfo().getDebugInfo().message(msg.getMessage().toString());
                } else if (actionSet == null) {
                    message = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0432 \u043e\u0431\u0449\u0438\u0445 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0439 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432\u0438\u043b, \u0430\u0432\u0442\u043e\u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0430\u0432\u0438\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 {0} \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e", (Object[])new Object[]{prod.getSystemNumber()});
                    ctx.addMessage(message);
                    productDetails.getDebugInfo().getDebugInfo().message(message.getMessage().toString());
                } else {
                    int voidTimeLimit = actionSet.getVoidTimelimit();
                    Date limit = MiscUtil.setDayEndTime((Date)prod.getIssueDate());
                    if (voidTimeLimit != -1) {
                        limit = new Date(prod.getIssueDate().getTime() + TimeUnit.MINUTES.toMillis(voidTimeLimit));
                    }
                    voidAllowed = voidAllowed && limit.after(((TimeService)Environment.getPublished(TimeService.class)).currentDate());
                    Message message2 = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0434\u043b\u044f \u0430\u0432\u0438\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 {0} \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0442\u0430\u0439\u043c-\u043b\u0438\u043c\u0438\u0442 {1}, \u0430\u0432\u0442\u043e\u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {2}", (Object[])new Object[]{prod.getSystemNumber(), limit, voidAllowed ? "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e" : "\u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e"});
                    ctx.addMessage(message2);
                    productDetails.getDebugInfo().getDebugInfo().message(message2.getMessage().toString());
                }
                if (actionSet == null) {
                    message = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0432 \u043e\u0431\u0449\u0438\u0445 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0439 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432\u0438\u043b, \u0430\u0432\u0442\u043e\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0434\u043b\u044f \u0430\u0432\u0438\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 {0} \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d", (Object[])new Object[]{prod.getSystemNumber()});
                    ctx.addMessage(message);
                    productDetails.getDebugInfo().getDebugInfo().message(message.getMessage().toString());
                } else {
                    refundAllowed = refundAllowed && !actionSet.isRefundForbidden();
                    message = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0434\u043b\u044f \u0430\u0432\u0438\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 {0} \u0430\u0432\u0442\u043e\u0432\u043e\u0437\u0432\u0440\u0430\u0442 {1}", (Object[])new Object[]{prod.getSystemNumber(), refundAllowed ? "\u043d\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u043c\u0438" : "\u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u043c\u0438"});
                    ctx.addMessage(message);
                    productDetails.getDebugInfo().getDebugInfo().message(message.getMessage().toString());
                }
                if (!voidAllowed) {
                    message = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e", (Object[])new Object[]{recordLocator});
                    ctx.addMessage(message);
                    productDetails.getDebugInfo().getDebugInfo().message(message.getMessage().toString());
                }
                if (!refundAllowed) {
                    message = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u043c\u0438", (Object[])new Object[]{recordLocator});
                    ctx.addMessage(message);
                    productDetails.getDebugInfo().getDebugInfo().message(message.getMessage().toString());
                }
                if (voidAllowed || refundAllowed) continue;
                break;
            }
            finally {
                productDetails.getDebugInfo().getDebugInfo().endBlock();
            }
        }
        ctx.putObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE, (Object)(voidAllowed ? Boolean.TRUE : Boolean.FALSE));
        ctx.putObject((Enum)IBusGdsContextKeys.AUTOREFUND_ALLOWED_BY_RULES, (Object)(refundAllowed ? Boolean.TRUE : Boolean.FALSE));
        if (voidAllowed) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0430\u0432\u0442\u043e\u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e", (Object[])new Object[]{recordLocator}));
        }
        if (refundAllowed) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0430\u0432\u0442\u043e\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u043d\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u043c\u0438", (Object[])new Object[]{recordLocator}));
        }
    }

    private CommonAirlineActionSet calcActionSet(Product prod, GdsProductRefundFinanceDetails productDetails, RuleSet ruleSet) throws Exception {
        if (ruleSet == null || ruleSet.getRules().isEmpty()) {
            return null;
        }
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyType(CommonAirlineTargets.UNSELL_RULES.getId());
        DebugInfo ruleDebugInfo = new DebugInfo();
        proxy.getTracer().setDebugInfo(ruleDebugInfo);
        proxy.setProxyDate(((TimeService)Environment.getPublished(TimeService.class)).currentDate());
        proxy.setPropertySet((Object)new GdsProductPropertySet(proxy));
        ((GdsProductPropertySet)((Object)proxy.getPropertySet())).init(prod);
        proxy.setActionSet((Object)new CommonAirlineActionSet());
        CommonAirlineActionSet actionSet = (CommonAirlineActionSet)proxy.getActionSet();
        actionSet.setVoidTimelimit(-1);
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)ruleSet);
        for (String ruleUid : proxy.getAppliedRules()) {
            RuleSettings rule = (RuleSettings)CollectionUtil.find((Iterable)ruleSet.getRules(), (String)ruleUid);
            if (rule == null) {
                proxy.getTracer().traceWarn(String.format("unable to find rule: uid=%s", ruleUid), null);
                continue;
            }
            proxy.getTracer().traceLogic(String.format("rule \u2116 %s was applied", Integer.toString(ruleSet.getRules().indexOf(rule) + 1)));
            AppliedRule ruleInfo = new AppliedRule();
            ruleInfo.setCalculationDate(((TimeService)Environment.getPublished(TimeService.class)).currentDate());
            ruleInfo.setProductUid(prod.getUid());
            ruleInfo.setRuleUid(rule.getUid());
            ruleInfo.setRuleName(rule.getName());
            ruleInfo.setRuleDescription(rule.getRestrictionsInfo());
            productDetails.getDebugInfo().getAppliedRules().add(ruleInfo);
        }
        productDetails.getDebugInfo().getDebugInfo().addBlock(ruleDebugInfo);
        return (CommonAirlineActionSet)proxy.getActionSet();
    }

    private boolean isTicketIssuedToday(Product prod, MessageContext ctx) {
        Calendar cal = this.getLocalCalendar(prod, ctx);
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.setTime(prod.getIssueDate());
        int issueYear = cal.get(1);
        int issueMonth = cal.get(2);
        int issueDate = cal.get(5);
        cal.setTime(((TimeService)Environment.getPublished(TimeService.class)).currentDate());
        int nowYear = cal.get(1);
        int nowMonth = cal.get(2);
        int nowDate = cal.get(5);
        return issueYear == nowYear && issueMonth == nowMonth && issueDate == nowDate;
    }

    private Calendar getLocalCalendar(Product prod, MessageContext ctx) {
        EntityContainer spCtr = EntityStorage.get().resolve(prod.getSalesPoint());
        if (spCtr == null || prod.getPcc() == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0}: \u043d\u0435 \u0437\u0430\u0434\u0430\u043d pcc \u0438\u043b\u0438 \u0442\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436, \u043d\u0435 \u0443\u0434\u0430\u0441\u0442\u0441\u044f \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u0430\u0442\u0443 \u0432\u044b\u043f\u0438\u0441\u043a\u0438", (Object[])new Object[]{prod.getSystemNumber()}));
            return null;
        }
        Collection pccs = ProfileHelper.filterPcc((Collection)((SalesPoint)spCtr.getEntity()).getPccs(), prod.getReservation().getGdsNameInfo().getSystemInfos().stream().map(ReservationSystemInfo::getGdsName).filter(Objects::nonNull).collect(Collectors.toSet()), Collections.singleton(prod.getPcc()), null, (Date)((TimeService)Environment.getPublished(TimeService.class)).currentDate());
        HashSet<String> timeZones = new HashSet<String>();
        for (Pcc pcc : pccs) {
            for (PccParameter param : pcc.getParameters()) {
                if (TextUtil.isBlank((String)param.getValue()) || param.getName() != PccParameterName.SABRE_TIME_ZONE) continue;
                timeZones.add(param.getValue());
            }
        }
        if (timeZones.size() == 0) {
            return null;
        }
        String timeZoneCode = (String)timeZones.iterator().next();
        if (timeZones.size() > 1) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0}: \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0447\u0430\u0441\u043e\u0432\u044b\u0445 \u043f\u043e\u044f\u0441\u043e\u0432 \u0434\u043b\u044f pcc {1} \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d {2}", (Object[])new Object[]{prod.getSystemNumber(), prod.getPcc(), timeZoneCode}));
        }
        if (!this.validTimeZoneCodes.contains(timeZoneCode)) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0}: \u043a\u043e\u0434 \u0447\u0430\u0441\u043e\u0432\u043e\u0433\u043e \u043f\u043e\u044f\u0441\u0430 {1} \u0434\u043b\u044f pcc {2} \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u0430\u043b\u0438\u0434\u043d\u044b\u043c", (Object[])new Object[]{prod.getSystemNumber(), timeZoneCode, prod.getPcc()}));
            return null;
        }
        return Calendar.getInstance(TimeZone.getTimeZone(timeZoneCode));
    }
}

