/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.autorefund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsCapabilities;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class CheckGdsCapabilitiesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GdsCapabilities gdsCapabilities = (GdsCapabilities)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_CAPABILITIES);
        String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
        if (!gdsCapabilities.isVoidSupported()) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0430\u0432\u0442\u043e\u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0430\u043d\u043e \u0432 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0435", (Object[])new Object[]{recordLocator}));
            ctx.putObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE, (Object)Boolean.FALSE);
            return;
        }
        if (!gdsCapabilities.isVoidWithMcoSupported() && GDSHelper.getMcoProductsStream(reservation.getProducts()).findAny().isPresent()) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0430\u0432\u0442\u043e\u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441 MCO \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430\u043c\u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0430\u043d\u043e \u0432 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0435", (Object[])new Object[]{recordLocator}));
            ctx.putObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE, (Object)Boolean.FALSE);
        }
    }
}

