/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.autovoid;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.TimeService;
import com.gridnine.xtrip.common.gds.model.CommonAirlineSettings;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineRulesHelper;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineTargets;
import com.gridnine.xtrip.common.gds.rules.airline.VoidSettingsActions;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.PccParameter;
import com.gridnine.xtrip.common.model.profile.PccParameterName;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.autorefund.AutoUnsellAnalyzerAviaProductsProcessor;
import com.gridnine.xtrip.server.gds.test.GDSTestBase;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class AutovoidAviaReservationDifferentTimezoneTest
extends GDSTestBase {
    Date currentDate;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH:mm");

    public void setUp() throws Exception {
        super.setUp();
        Environment.unpublish(TimeService.class);
        Environment.publish(TimeService.class, (Object)new TimeService(){

            public long currentTimeMillis() {
                return AutovoidAviaReservationDifferentTimezoneTest.this.currentDate == null ? System.currentTimeMillis() : AutovoidAviaReservationDifferentTimezoneTest.this.currentDate.getTime();
            }

            public Date currentDate() {
                return AutovoidAviaReservationDifferentTimezoneTest.this.currentDate == null ? new Date() : AutovoidAviaReservationDifferentTimezoneTest.this.currentDate;
            }
        });
    }

    @Test
    public void testVoidPossible() throws Throwable {
        this.currentDate = this.sdf.parse("2015-01-02_00:45");
        Date issueDate = this.sdf.parse("2015-01-02_00:24");
        EntityReference sp = TestBookingFileBuilder.agencySalesPoint;
        EntityContainer commonAirlineSettingsContainer = CommonAirlineRulesHelper.getCommonAirlineSettingsContainer();
        ((CommonAirlineSettings)commonAirlineSettingsContainer.getEntity()).setRuleSet(this.createRuleSet());
        EntityStorage.get().save(commonAirlineSettingsContainer, true);
        EntityContainer ctr = EntityStorage.get().resolve(sp);
        Pcc pcc = new Pcc();
        pcc.setGdsName(GdsName.SABRE);
        pcc.setAgency(TestBookingFileBuilder.agency);
        String pccCode = "0001";
        pcc.setCode(pccCode);
        PccParameter pccParameter = new PccParameter();
        pccParameter.setName(PccParameterName.SABRE_TIME_ZONE);
        pccParameter.setValue("Europe/Moscow");
        pcc.getParameters().add(pccParameter);
        ((SalesPoint)ctr.getEntity()).getPccs().add(pcc);
        EntityStorage.get().save(ctr, true);
        Reservation res = new TestBookingFileBuilder(true).reservation(true).recordLocator(GdsName.SABRE, RecordLocatorType.DEFAULT, "TESTRL").airProduct(true).issueDate(issueDate).pcc(pccCode).end().getEntity();
        AutoUnsellAnalyzerAviaProductsProcessor proc = new AutoUnsellAnalyzerAviaProductsProcessor();
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)res);
        ctx.putObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST, this.createRequest(res));
        proc.process(ctx);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE));
    }

    @Test
    public void testVoidImpossible() throws Throwable {
        this.currentDate = this.sdf.parse("2015-01-02_11:45");
        Date issueDate = this.sdf.parse("2015-01-02_00:24");
        EntityReference sp = TestBookingFileBuilder.agencySalesPoint;
        EntityContainer ctr = EntityStorage.get().resolve(sp);
        EntityContainer commonAirlineSettingsContainer = CommonAirlineRulesHelper.getCommonAirlineSettingsContainer();
        ((CommonAirlineSettings)commonAirlineSettingsContainer.getEntity()).setRuleSet(this.createRuleSet());
        EntityStorage.get().save(commonAirlineSettingsContainer, true);
        Pcc pcc = new Pcc();
        pcc.setGdsName(GdsName.SABRE);
        pcc.setAgency(TestBookingFileBuilder.agency);
        String pccCode = "0001";
        pcc.setCode(pccCode);
        PccParameter pccParameter = new PccParameter();
        pccParameter.setName(PccParameterName.SABRE_TIME_ZONE);
        pccParameter.setValue("Europe/Berlin");
        pcc.getParameters().add(pccParameter);
        ((SalesPoint)ctr.getEntity()).getPccs().add(pcc);
        EntityStorage.get().save(ctr, true);
        Reservation res = new TestBookingFileBuilder(true).reservation(true).recordLocator(GdsName.SABRE, RecordLocatorType.DEFAULT, "TESTRL").airProduct(true).issueDate(issueDate).pcc(pccCode).end().getEntity();
        AutoUnsellAnalyzerAviaProductsProcessor proc = new AutoUnsellAnalyzerAviaProductsProcessor();
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)res);
        ctx.putObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST, this.createRequest(res));
        proc.process(ctx);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE));
    }

    private RuleSet createRuleSet() {
        RuleSet result = new RuleSet();
        RuleSettings ruleSettings = new RuleSettings();
        result.getRules().add(ruleSettings);
        ruleSettings.setTarget((RuleTarget)CommonAirlineTargets.UNSELL_RULES);
        RuleResult rr = new RuleResult();
        rr.setAction((RuleAction)VoidSettingsActions.VOID_TIMELIMIT);
        rr.setValue((Object)120.0);
        ruleSettings.getResults().add(rr);
        return result;
    }

    private Map<String, ProductStatus> createRequest(Reservation res) {
        return Collections.singletonMap(((BaseProduct)res.getProducts().get(0)).getUid(), ProductStatus.REFUND);
    }
}

