/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.autovoid;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineTargets;
import com.gridnine.xtrip.common.gds.rules.airline.VoidSettingsActions;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.autorefund.AutoUnsellAnalyzerAviaProductsProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateUtils;
import org.junit.Assert;
import org.junit.Test;

public class AutovoidAviaReservationProcessorTest
extends ModelTestBase {
    @Test
    public void testAutovoidPossible() throws Throwable {
        Reservation res = new TestBookingFileBuilder(true).reservation(true).airProduct(true).systemNumber("0000000001").end().getEntity();
        Product product = (Product)res.getProducts().get(0);
        product.setIssueDate(MiscUtil.clearTime((Date)new Date()));
        EntityReference sp = TestBookingFileBuilder.agencySalesPoint;
        EntityContainer ctr = EntityStorage.get().resolve(sp);
        ((SalesPoint)ctr.getEntity()).setRuleSet(this.createRuleSet());
        EntityStorage.get().save(ctr, true);
        AutoUnsellAnalyzerAviaProductsProcessor proc = new AutoUnsellAnalyzerAviaProductsProcessor();
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)res);
        ctx.putObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST, this.createRequest(res));
        proc.process(ctx);
        Assert.assertTrue((boolean)((Boolean)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE)));
    }

    @Test
    public void testAutovoidImpossibleWrongDate() throws Throwable {
        Reservation res = new TestBookingFileBuilder(true).reservation(true).airProduct(true).systemNumber("0000000001").end().getEntity();
        Product product = (Product)res.getProducts().get(0);
        product.setIssueDate(MiscUtil.clearTime((Date)DateUtils.addDays((Date)new Date(), (int)-2)));
        EntityReference sp = TestBookingFileBuilder.agencySalesPoint;
        EntityContainer ctr = EntityStorage.get().resolve(sp);
        ((SalesPoint)ctr.getEntity()).setRuleSet(this.createRuleSet());
        EntityStorage.get().save(ctr, true);
        AutoUnsellAnalyzerAviaProductsProcessor proc = new AutoUnsellAnalyzerAviaProductsProcessor();
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)res);
        ctx.putObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST, this.createRequest(res));
        proc.process(ctx);
        Assert.assertFalse((boolean)((Boolean)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE)));
        List actMessages = ctx.getMessagesReadOnly().stream().filter(mes -> mes.getType() == MessageType.MESSAGE).map(Message::getMessage).map(L10nMessage::toString).collect(Collectors.toList());
        List<String> expMessages = Arrays.asList("\u0434\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438 \u0432 \u0430\u0432\u0438\u0430 \u0443\u0441\u043b\u0443\u0433\u0435 0000000001 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0430\u0442\u043e\u0439, \u0430\u0432\u0442\u043e\u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e", "\u0432 \u043e\u0431\u0449\u0438\u0445 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0439 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432\u0438\u043b, \u0430\u0432\u0442\u043e\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0434\u043b\u044f \u0430\u0432\u0438\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 0000000001 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d", "\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f ASDFG \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e", "\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f ASDFG \u0430\u0432\u0442\u043e\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u043d\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u043c\u0438");
        Assert.assertEquals((Object)expMessages.toString(), (Object)actMessages.toString());
    }

    @Test
    public void testAutovoidImpossibleNoDate() throws Throwable {
        Reservation res = new TestBookingFileBuilder(true).reservation(true).airProduct(true).systemNumber("0000000001").end().getEntity();
        Product product = (Product)res.getProducts().get(0);
        product.setIssueDate(null);
        EntityReference sp = TestBookingFileBuilder.agencySalesPoint;
        EntityContainer ctr = EntityStorage.get().resolve(sp);
        ((SalesPoint)ctr.getEntity()).setRuleSet(this.createRuleSet());
        EntityStorage.get().save(ctr, true);
        AutoUnsellAnalyzerAviaProductsProcessor proc = new AutoUnsellAnalyzerAviaProductsProcessor();
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)res);
        ctx.putObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST, this.createRequest(res));
        proc.process(ctx);
        Assert.assertFalse((boolean)((Boolean)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE)));
        Assert.assertEquals((long)1L, (long)ctx.getMessagesReadOnly().size());
        Message msg = (Message)ctx.getMessagesReadOnly().iterator().next();
        Assert.assertEquals((Object)"\u0432 \u0430\u0432\u0438\u0430 \u0443\u0441\u043b\u0443\u0433\u0435 0000000001 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438", (Object)msg.getMessage().toString());
    }

    @Test
    public void testAutovoidImpossibleNoProducts() throws Throwable {
        Reservation res = new TestBookingFileBuilder(true).reservation(true).airProduct(true).systemNumber("0000000001").end().getEntity();
        EntityReference sp = TestBookingFileBuilder.agencySalesPoint;
        EntityContainer ctr = EntityStorage.get().resolve(sp);
        ((SalesPoint)ctr.getEntity()).setRuleSet(this.createRuleSet());
        EntityStorage.get().save(ctr, true);
        AutoUnsellAnalyzerAviaProductsProcessor proc = new AutoUnsellAnalyzerAviaProductsProcessor();
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)res);
        ctx.putObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST, this.createRequest(res));
        proc.process(ctx);
        Assert.assertFalse((boolean)((Boolean)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE)));
    }

    @Test
    public void testAutovoidImpossibleWrongProductStatus() throws Throwable {
        this.wrongProductStatusTestLogic(ProductStatus.BOOKING);
        this.wrongProductStatusTestLogic(ProductStatus.EXCHANGE);
        this.wrongProductStatusTestLogic(ProductStatus.REFUND);
        this.wrongProductStatusTestLogic(ProductStatus.VOID);
        this.wrongProductStatusTestLogic(ProductStatus.VOID_BOOKING);
    }

    private void wrongProductStatusTestLogic(ProductStatus status) throws Throwable {
        Reservation res = new TestBookingFileBuilder(true).reservation(true).airProduct(true).systemNumber("0000000001").end().getEntity();
        Product product = (Product)res.getProducts().get(0);
        product.setIssueDate(MiscUtil.clearTime((Date)new Date()));
        product.setStatus(status);
        EntityReference sp = TestBookingFileBuilder.agencySalesPoint;
        EntityContainer ctr = EntityStorage.get().resolve(sp);
        ((SalesPoint)ctr.getEntity()).setRuleSet(this.createRuleSet());
        EntityStorage.get().save(ctr, true);
        AutoUnsellAnalyzerAviaProductsProcessor proc = new AutoUnsellAnalyzerAviaProductsProcessor();
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)res);
        ctx.putObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST, this.createRequest(res));
        proc.process(ctx);
        Assert.assertFalse((boolean)((Boolean)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AUTOVOID_POSSIBLE)));
        Assert.assertEquals((long)1L, (long)ctx.getMessagesReadOnly().size());
        Message msg = (Message)ctx.getMessagesReadOnly().iterator().next();
        Assert.assertEquals((Object)"\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f ASDFG \u043d\u0435\u0442 \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", (Object)msg.getMessage().toString());
    }

    private RuleSet createRuleSet() {
        RuleSet result = new RuleSet();
        RuleSettings ruleSettings = new RuleSettings();
        result.getRules().add(ruleSettings);
        ruleSettings.setTarget((RuleTarget)CommonAirlineTargets.AIRLINE_RULES);
        RuleResult rr = new RuleResult();
        rr.setAction((RuleAction)VoidSettingsActions.VOID_TIMELIMIT);
        rr.setValue((Object)120.0);
        ruleSettings.getResults().add(rr);
        return result;
    }

    private Map<String, ProductStatus> createRequest(Reservation res) {
        return Collections.singletonMap(((BaseProduct)res.getProducts().get(0)).getUid(), ProductStatus.REFUND);
    }
}

