/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.cityFilter;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.AirlineCityInfo;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CityFilterAirlineCityInfoCreator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Set citiesCodes = (Set)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CITY_FILTER_CITIES);
        DictionaryReference airlineRef = (DictionaryReference)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AIRLINE);
        if (citiesCodes.isEmpty()) {
            return;
        }
        Collection airlineCityInfos = DictionaryCache.get().getAll(AirlineCityInfo.class).values();
        AirlineCityInfo airlineCityInfo = null;
        for (AirlineCityInfo aci : airlineCityInfos) {
            if (!aci.getAirline().equals((Object)airlineRef)) continue;
            airlineCityInfo = aci;
            break;
        }
        if (airlineCityInfo == null) {
            airlineCityInfo = new AirlineCityInfo();
            airlineCityInfo.setAirline(airlineRef);
        }
        HashSet<String> missedCityCodes = null;
        HashSet<GeoLocationReference> geoLocations = new HashSet<GeoLocationReference>();
        for (String code : citiesCodes) {
            GeoLocation city = DictHelper.findCityByAirport((String)code);
            if (city == null) {
                missedCityCodes = new HashSet<String>();
                missedCityCodes.add(code);
                continue;
            }
            geoLocations.add(city.toReference());
        }
        Set cities = airlineCityInfo.getCities();
        boolean isChanged = cities.retainAll(geoLocations);
        boolean bl = isChanged = cities.addAll(geoLocations) || isChanged;
        if (isChanged) {
            airlineCityInfo.setDataSource("GdsTask-cityFilter");
            DictionaryStorage.get().save((BaseDictionary)airlineCityInfo);
        }
        if (!missedCityCodes.isEmpty()) {
            throw Xeption.forAdmin((String)("Missed cities code: " + missedCityCodes), (Object[])new Object[0]);
        }
    }
}

