/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.corteos;

import com.gridnine.xtrip.common.util.TextUtil;

public enum CorteosEndpoint {
    AUTHORIZATION("XmlGate/V3/Authorization.asmx"),
    AGREEMENT_MANAGEMENT("XmlGate/V3/StaticData/Agreements/AgreementManagement.asmx"),
    TOKEN_GENERATOR("XmlGate/V3/TokenGenerator/TokenGenerator.asmx"),
    PERSON_MANAGEMENT("XmlGate/V3/StaticData/Persons/PersonManagement.asmx"),
    TRAVEL_POLICY_MANAGEMENT("XmlGate/V3/StaticData/TravelPolicies/TravelPolicyManagement.asmx"),
    ORCHESTRATED_PERSON_EDITOR("XmlGate/V3/Orchestrated/OrchestratedPersonEditor.asmx"),
    ORDERS_API("XmlGate/V3/OrderManagement/OrdersAPI.asmx");

    private final String endpoint;

    private CorteosEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String createUrl(String serverAddress) {
        TextUtil.requireNonBlank((String)serverAddress, (String)"Server address is missing");
        String address = serverAddress.trim();
        if (!address.trim().endsWith("/")) {
            address = address + "/";
        }
        return address + this.endpoint;
    }
}

