/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.corteos;

import com.gridnine.xtrip.common.gds.ibus.corteos.IbusCorteosContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.corteos.CorteosEndpoint;
import com.gridnine.xtrip.server.gds.ibus.corteos.CorteosServiceAction;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.ContentEncoding;
import com.gridnine.xtrip.server.jibxws.IBusJibxWsContextKeys;
import com.gridnine.xtrip.server.jibxws.WsRequest;
import java.util.EnumSet;
import ru.corteos.AuthHeader;
import ru.corteos.AuthorizationToken;

public class CorteosWsRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Object payload = ctx.getMandatoryObject((Enum)IbusCorteosContextKeys.CORTEOS_WS_REQUEST_PAYLOAD);
        AuthorizationToken authToken = (AuthorizationToken)ctx.getObject((Enum)IbusCorteosContextKeys.AUTHORIZATION_TOKEN);
        CorteosServiceAction action = (CorteosServiceAction)((Object)ctx.getMandatoryObject((Enum)IbusCorteosContextKeys.CORTEOS_SERVICE_ACTION));
        CorteosEndpoint endpoint = (CorteosEndpoint)((Object)ctx.getMandatoryObject((Enum)IbusCorteosContextKeys.ENDPOINT));
        String serverAddress = (String)ctx.getMandatoryObject((Enum)IbusCorteosContextKeys.SERVICE_ADDRESS);
        EntityContainer organization = (EntityContainer)ctx.getObject((Enum)IbusCorteosContextKeys.ORGANIZATION);
        if (organization != null && ((Organization)organization.getEntity()).getCorteosSettings() != null && TextUtil.nonBlank((String)((Organization)organization.getEntity()).getCorteosSettings().getServerAddress())) {
            serverAddress = ((Organization)organization.getEntity()).getCorteosSettings().getServerAddress();
        }
        WsRequest request = new WsRequest();
        if (authToken != null) {
            AuthHeader authHeader = new AuthHeader();
            authHeader.setToken(authToken.getTokenValue());
            request.getHeaders().add(authHeader);
        }
        String url = endpoint.createUrl(serverAddress);
        request.getHttpHeaders().put("SOAPAction", new String[]{action.getValue()});
        request.setPayload(payload);
        request.setAcceptEncoding(EnumSet.allOf(ContentEncoding.class));
        request.setEndpointAddress(url);
        request.setReadTimeout(Integer.valueOf(300000));
        ctx.putObject((Enum)IBusJibxWsContextKeys.WS_REQUEST, (Object)request);
        ctx.removeObject((Enum)IbusCorteosContextKeys.CORTEOS_WS_REQUEST_PAYLOAD);
        ctx.removeObject((Enum)IbusCorteosContextKeys.CORTEOS_SERVICE_ACTION);
        ctx.removeObject((Enum)IbusCorteosContextKeys.ENDPOINT);
    }
}

