/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.HashSet;

public class BindSelectFlightFlightContentToBookingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        TemporalObject to = (TemporalObject)AssetsStorage.get().load(TemporalObject.class, GDSHelper.getFlightContentTemporalObjectUid(flight));
        if (to == null) {
            return;
        }
        Flight document = new Flight();
        XUtil.fromBytes((byte[])to.getData(), (XSerializable)document);
        Document doc = new Document();
        doc.setContent(to.getData());
        doc.setContentType(ContentType.XML);
        doc.setCreated(new Date());
        doc.setDescription("flight-trace");
        doc.setName("select-flight.xml");
        doc.setOwner(bfCtr.toReference());
        doc.setNavigationKey(((BookingFile)bfCtr.getEntity()).getUid());
        doc.setType(DocumentType.GDS_LOG);
        doc.setTitle(doc.getDescription());
        HashSet<Document> documents = (HashSet<Document>)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS);
        if (documents == null) {
            documents = new HashSet<Document>();
            ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS, documents);
        }
        documents.add(doc);
        AssetsStorage.get().delete((BaseAsset)to);
    }
}

