/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.createReservation.remarks;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.server.gds.corp.AbstractAFS;
import com.gridnine.xtrip.server.gds.corp.FlightAFS;
import com.gridnine.xtrip.server.gds.corp.StatHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public final class AfsFlightRemarkProcessor
extends BaseProcessor {
    boolean isTicketing;
    boolean noGdsRemarks;

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.isTicketing = Boolean.parseBoolean(parameters.get("ticketing"));
        this.noGdsRemarks = Boolean.parseBoolean(parameters.get("no_gds_remarks"));
    }

    public void process(MessageContext ctx) throws Exception {
        AFSType afsType = (AFSType)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AFS_TYPE);
        FlightAFS afs = AbstractAFS.getFlightAFS(afsType);
        if (afs == null) {
            throw Xeption.forDeveloper((String)"No flight AFS found for AFSType: ", (Object[])new Object[]{afsType.name()});
        }
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        Object value = afs.getStatisticalValue(flight);
        if (value == null) {
            if (afsType != AFSType.DEST) {
                this.log.error("Tried to get flight statistical value for " + afsType.name() + " but got null, please check XML config");
            }
        } else {
            StatisticalData statData = StatHelper.getStatisticalData(ctx);
            afs.saveValueToMOM(value, statData, this.isTicketing);
            if (!this.noGdsRemarks) {
                ctx.putObject("AFS_STAT_VALUE", value);
            }
        }
    }
}

