/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.createReservation.remarks;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.corp.CorporateBookingParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfsTargetsProvider
extends BaseTargetsProvider<AFSType> {
    protected final transient Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean isTicketing;
    private boolean optional;

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.isTicketing = Boolean.parseBoolean(parameters.get("is_ticketing"));
        this.optional = Boolean.parseBoolean(parameters.get("optional"));
    }

    public Collection<AFSType> getTargets(MessageContext ctx) throws Exception {
        CorporateBookingParameters cbp = (CorporateBookingParameters)ctx.getObject((Enum)IBusGdsContextKeys.CORPORATE_BOOKING_PARAMETERS);
        if (cbp == null) {
            return Collections.emptySet();
        }
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Organization client = (Organization)EntityStorage.get().resolve(salesContext.getClient()).getEntity();
        return StatisticsHelper.getAfsTypesFromString((String)client.getAfsSettings(), (boolean)this.isTicketing);
    }
}

