/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.createReservation.validation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.server.gds.ibus.createReservation.validation.GdsValidationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

public class GdsReservationCustomerValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Customer customer = (Customer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
        this.validateCustomer(customer, salesContext);
    }

    private void validateCustomer(Customer customer, SalesContext salesContext) {
        GdsValidationHelper.validateCommunications(customer.getCommunications());
        if (ProfileHelper.getPhoneCommunications((List)customer.getCommunications()).isEmpty()) {
            customer.getValidationContext().getCommunicationsValidationMessages().add(GdsValidationMessages.getMissingCustomerPhone());
        }
        if (ProfileHelper.filterCommunications((Collection)customer.getCommunications(), EnumSet.of(CommunicationType.EMAIL)).isEmpty()) {
            customer.getValidationContext().getCommunicationsValidationMessages().add(GdsValidationMessages.getMissingCustomerEmail());
        }
    }
}

