/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.createReservation.validation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.AgeRestriction;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.createReservation.validation.GdsValidationHelper;
import com.gridnine.xtrip.server.gds.ibus.createReservation.validation.TravellerWrapper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;

public class GdsReservationTravellerBirthdayValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        TravellerWrapper travellerWrapper = (TravellerWrapper)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_TRAVELLER);
        this.validateBirthday(travellerWrapper.getTraveller().getPassport(), (DictionaryReference<PassengerType>)travellerWrapper.getGdsTraveller().getPassengerType(), parameters.getFlight());
    }

    private void validateBirthday(Passport passport, DictionaryReference<PassengerType> passengerType, Flight flight) {
        int years;
        if (passport == null || passengerType == null || flight == null) {
            return;
        }
        if (passport.getBirthday() == null) {
            passport.getValidationContext().getBirthdayValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            return;
        }
        Date firstFlightDate = GdsValidationHelper.getFirstFlightDate(flight);
        AgeRestriction ageRestriction = null;
        if (DictHelper.isInfantPassengerTypeCategory(passengerType)) {
            ageRestriction = new AgeRestriction(null, null, Integer.valueOf(2), Boolean.TRUE);
        } else if (DictHelper.isChildPassengerTypeCategory(passengerType)) {
            ageRestriction = new AgeRestriction(Integer.valueOf(2), Boolean.FALSE, Integer.valueOf(12), Boolean.TRUE);
        } else if (DictHelper.isEqualsPredifinedValue(passengerType, (DictPredifinedValueProvider[])new DictPredifinedValueProvider[]{PassengerTypeValue.YOUTH})) {
            ageRestriction = new AgeRestriction(Integer.valueOf(12), Boolean.FALSE, Integer.valueOf(22), Boolean.TRUE);
        } else if (DictHelper.isEqualsPredifinedValue(passengerType, (DictPredifinedValueProvider[])new DictPredifinedValueProvider[]{PassengerTypeValue.SENIOR})) {
            if (passport.getGender() != null) {
                switch (passport.getGender()) {
                    case FEMALE: {
                        ageRestriction = new AgeRestriction(Integer.valueOf(55), Boolean.FALSE, null, null);
                        break;
                    }
                    case MALE: {
                        ageRestriction = new AgeRestriction(Integer.valueOf(60), Boolean.FALSE, null, null);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            ageRestriction = new AgeRestriction(Integer.valueOf(12), Boolean.FALSE, Integer.valueOf(150), Boolean.TRUE);
        }
        if (ageRestriction != null) {
            ageRestriction.validate(passport.getBirthday(), firstFlightDate, passport.getValidationContext().getBirthdayValidationMessages());
        }
        Date lastFlightDate = GdsValidationHelper.getLastFlightDate(flight);
        if (passport.getType() == PassportType.BIRTHDAY_NOTIFICATION && lastFlightDate != null && (years = Years.yearsBetween((ReadableInstant)new DateTime((Object)passport.getBirthday()), (ReadableInstant)new DateTime((Object)lastFlightDate)).getYears()) >= 14) {
            passport.getValidationContext().getTypeValidationMessages().add(GdsValidationMessages.getBirthdayNotificationWillExpire());
        }
    }
}

