/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.createReservation.validation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.FrequentFlyerHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.createReservation.validation.GdsValidationHelper;
import com.gridnine.xtrip.server.gds.ibus.createReservation.validation.TravellerWrapper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GdsReservationTravellerValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        TravellerWrapper travellerWrapper = (TravellerWrapper)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_TRAVELLER);
        this.validateTraveller(travellerWrapper, parameters.getFlight());
    }

    private void validateTraveller(TravellerWrapper travellerWr, Flight flight) {
        Traveller traveller = travellerWr.getTraveller();
        GdsTraveller gdsTraveller = travellerWr.getGdsTraveller();
        if (gdsTraveller.getPassengerType() == null) {
            gdsTraveller.getValidationContext().getPassengerTypeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (traveller.getPassport() == null) {
            traveller.getValidationContext().getPassportValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        } else {
            this.validatePassport(traveller.getPassport(), flight);
        }
        GdsValidationHelper.validateCommunications(traveller.getCommunications());
        this.validateAirlineBonusCards(traveller.getAirlineBonusCards(), flight);
    }

    private void validatePassport(Passport passport, Flight flight) {
        this.basicNameValidation(passport.getLastName(), flight, true, passport.getValidationContext().getLastNameValidationMessages());
        this.basicNameValidation(passport.getFirstName(), flight, true, passport.getValidationContext().getFirstNameValidationMessages());
        this.checkSameLanguage(passport, flight);
        if (passport.getGender() == null) {
            passport.getValidationContext().getGenderValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (passport.getIssued() != null && !passport.getIssued().before(new Date())) {
            passport.getValidationContext().getIssuedValidationMessages().add(GdsValidationMessages.getDateTooEarly());
        }
        Date lastFlightDate = GdsValidationHelper.getLastFlightDate(flight);
        if (passport.getExpired() != null && lastFlightDate != null && !passport.getExpired().after(lastFlightDate)) {
            passport.getValidationContext().getExpiredValidationMessages().add(GdsValidationMessages.getDateTooEarly());
        }
    }

    private void basicNameValidation(String name, Flight flight, boolean notEmpty, Collection<ValidationMessage> messages) {
        if (TextUtil.isBlank((String)name)) {
            if (notEmpty) {
                messages.add(StandardValidationMessages.getMissingRequiredValue());
            }
            return;
        }
        ValidationMessage mes = this.checkName(name, flight);
        if (mes != null) {
            messages.add(mes);
        }
    }

    private ValidationMessage checkName(String name, Flight flight) {
        if (flight == null) {
            return null;
        }
        if (!ValidationUtil.containsOnlyLatinLetters((String)name)) {
            if (flight.isLatinRegistration()) {
                return GdsValidationMessages.getAllowedLatinLettersOnly();
            }
            if (!ValidationUtil.containsOnlyCyrillicLetters((String)name)) {
                return GdsValidationMessages.getAllowedLatinOrCyrillicWithoutMix();
            }
        }
        return null;
    }

    private void checkSameLanguage(Passport passport, Flight flight) {
        Passport.PassportValidationContext vc = passport.getValidationContext();
        if (!(vc.getLastNameValidationMessages().isEmpty() && vc.getLastNameValidationMessages().isEmpty() && vc.getLastNameValidationMessages().isEmpty())) {
            return;
        }
        String fullName = TextUtil.join((String)"", Arrays.asList(passport.getLastName(), passport.getFirstName(), passport.getLastName()), (boolean)true);
        ValidationMessage mes = this.checkName(fullName, flight);
        if (mes != null) {
            if (!TextUtil.isBlank((String)passport.getLastName())) {
                vc.getLastNameValidationMessages().add(mes);
            }
            if (!TextUtil.isBlank((String)passport.getFirstName())) {
                vc.getFirstNameValidationMessages().add(mes);
            }
            if (!TextUtil.isBlank((String)passport.getMiddleName())) {
                vc.getMiddleNameValidationMessages().add(mes);
            }
        }
    }

    private void validateAirlineBonusCards(List<BookingAirlineBonusCard> airlineBonusCards, Flight flight) {
        for (BookingAirlineBonusCard bonusCard : airlineBonusCards) {
            this.validateAirlineBonusCard(bonusCard, flight);
        }
    }

    private void validateAirlineBonusCard(BookingAirlineBonusCard card, Flight flight) {
        if (card.getAirline() == null) {
            card.getValidationContext().getAirlineValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        } else {
            Airline airline = (Airline)DictionaryCache.get().resolveReference(card.getAirline());
            if (airline == null) {
                card.getValidationContext().getAirlineValidationMessages().add(StandardValidationMessages.getInvalidDictionaryReference());
            } else if (!FrequentFlyerHelper.isApplicableBonusCard(flight, (AirlineBonusCard)card, false, true)) {
                card.getValidationContext().getAirlineValidationMessages().add(StandardValidationMessages.getWrongValue());
            }
        }
        GdsValidationHelper.validateMandatoryNumberField(card.getNumber(), card.getValidationContext().getNumberValidationMessages());
    }
}

