/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.createReservation.validation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.createReservation.validation.TravellerWrapper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GdsReservationTravellerWrappersBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        ctx.putObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_TRAVELLERS, this.buildTravellers(parameters, travellers));
    }

    private List<TravellerWrapper> buildTravellers(GdsReservationCreationParameters parameters, Collection<Traveller> travellers) {
        ArrayList<TravellerWrapper> result = new ArrayList<TravellerWrapper>();
        for (GdsTraveller gdsTraveller : parameters.getGdsTravellers()) {
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid());
            if (traveller == null) {
                throw Xeption.forDeveloper((String)"traveller with uid '{0}' referenced in parameters for reservation system account '{1}' not found in context", (Object[])new Object[]{gdsTraveller.getTravellerUid(), parameters.getGdsAccount()});
            }
            result.add(new TravellerWrapper(gdsTraveller, traveller));
        }
        return result;
    }
}

