/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.createReservation.validation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.createReservation.validation.TravellerWrapper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GdsReservationTravellersValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellerWrappers = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_TRAVELLERS);
        if (parameters.getGdsTravellers().isEmpty()) {
            parameters.getValidationContext().getGdsTravellersValidationMessages().add(StandardValidationMessages.getEmptyCollection());
        } else {
            this.validateTravellers(travellerWrappers);
        }
    }

    private void validateTravellers(Collection<TravellerWrapper> travellerWrappers) {
        this.validateDocumentNumbers(travellerWrappers);
        this.validateBonusCards(travellerWrappers);
        this.ckeckOneTravellerPhone(travellerWrappers);
    }

    private void validateDocumentNumbers(Collection<TravellerWrapper> trWrappers) {
        if (trWrappers.isEmpty()) {
            return;
        }
        ArrayList<String> docNumbers = new ArrayList<String>();
        for (TravellerWrapper wr : trWrappers) {
            Passport psp = wr.getTraveller().getPassport();
            if (psp == null || TextUtil.isBlank((String)psp.getNumber()) || psp.getType() == null || !DictHelper.isAdultPassengerTypeCategory((DictionaryReference)wr.getGdsTraveller().getPassengerType())) continue;
            String number = String.format("%s-%s", psp.getNumber(), psp.getType().name());
            if (docNumbers.contains(number)) {
                psp.getValidationContext().getNumberValidationMessages().add(GdsValidationMessages.getDuplicateDocumentNumber());
                continue;
            }
            docNumbers.add(number);
        }
    }

    private void validateBonusCards(Collection<TravellerWrapper> trWrappers) {
        if (trWrappers.isEmpty()) {
            return;
        }
        ArrayList<String> cardNumbers = new ArrayList<String>();
        for (TravellerWrapper wr : trWrappers) {
            for (BookingAirlineBonusCard card : wr.getTraveller().getAirlineBonusCards()) {
                if (card.getAirline() == null || TextUtil.isBlank((String)card.getNumber())) continue;
                String number = String.format("%s-%s", card.getAirline().getCode(), card.getNumber());
                if (cardNumbers.contains(number)) {
                    card.getValidationContext().getNumberValidationMessages().add(GdsValidationMessages.getDuplicateAirlineBonusCard());
                    continue;
                }
                cardNumbers.add(number);
            }
        }
    }

    private void ckeckOneTravellerPhone(Collection<TravellerWrapper> trWrappers) {
        if (trWrappers.isEmpty()) {
            return;
        }
        for (TravellerWrapper wr : trWrappers) {
            if (ProfileHelper.getPhoneCommunications((List)wr.getTraveller().getCommunications()).isEmpty()) continue;
            return;
        }
        trWrappers.iterator().next().getTraveller().getValidationContext().getCommunicationsValidationMessages().add(GdsValidationMessages.getMissingTravellersPhone());
    }
}

