/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.createReservation.validation;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Date;

public class GdsValidationHelper {
    public static Date getFirstFlightDate(Flight flight) {
        if (flight == null) {
            return null;
        }
        if (flight.getSegmentTariffs().isEmpty()) {
            return null;
        }
        FlightSegmentTariff fst = (FlightSegmentTariff)flight.getSegmentTariffs().get(0);
        if (fst.getSegments().isEmpty()) {
            return null;
        }
        return ((FlightSegment)fst.getSegments().get(0)).getDateBegin();
    }

    public static Date getLastFlightDate(Flight flight) {
        if (flight == null) {
            return null;
        }
        if (flight.getSegmentTariffs().isEmpty()) {
            return null;
        }
        FlightSegmentTariff fst = (FlightSegmentTariff)flight.getSegmentTariffs().get(flight.getSegmentTariffs().size() - 1);
        if (fst.getSegments().isEmpty()) {
            return null;
        }
        return ((FlightSegment)fst.getSegments().get(fst.getSegments().size() - 1)).getDateEnd();
    }

    public static void validateCommunications(Collection<Communication> communications) {
        for (Communication comm : communications) {
            if (comm.getType() == null) {
                comm.getValidationContext().getTypeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
                continue;
            }
            switch (comm.getType()) {
                case HOME_PHONE: 
                case WORK_PHONE: 
                case MOBILE: {
                    GdsValidationHelper.validateMandatoryNumberField(comm.getCountryCode(), comm.getValidationContext().getCountryCodeValidationMessages());
                    GdsValidationHelper.validateMandatoryNumberField(comm.getCityCode(), comm.getValidationContext().getCityCodeValidationMessages());
                    GdsValidationHelper.validateMandatoryNumberField(comm.getSense(), comm.getValidationContext().getSenseValidationMessages());
                    break;
                }
                case EMAIL: {
                    if (TextUtil.isBlank((String)comm.getSense())) {
                        comm.getValidationContext().getSenseValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
                        break;
                    }
                    if (TextUtil.isValidEmailAddress((String)comm.getSense())) break;
                    comm.getValidationContext().getSenseValidationMessages().add(StandardValidationMessages.getWrongValue());
                    break;
                }
            }
        }
    }

    public static void validateMandatoryNumberField(String value, Collection<ValidationMessage> messages) {
        if (TextUtil.isBlank((String)value)) {
            messages.add(StandardValidationMessages.getMissingRequiredValue());
        } else if (!ValidationUtil.containsOnlyDigits((String)value)) {
            messages.add(GdsValidationMessages.getAllowDigitsOnly());
        }
    }
}

