/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.exchange;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.ExchangeParameters;
import com.gridnine.xtrip.common.gds.model.ExchangeRouteSegment;
import com.gridnine.xtrip.common.midoffice.ReservationStatusHandler;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class AutoexchangeCheckProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ExchangeParameters exchangeParams = (ExchangeParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.EXCHANGE_PARAMS);
        if (!this.isCorrectStatus(reservation)) {
            throw Xeption.forDeveloper((String)"invalid status", (Object[])new Object[0]);
        }
        if (!this.hasChangedLegs(exchangeParams)) {
            throw Xeption.forDeveloper((String)"no changed legs", (Object[])new Object[0]);
        }
        if (this.hasMco(reservation)) {
            throw Xeption.forDeveloper((String)"reservation with mco isn't supported", (Object[])new Object[0]);
        }
    }

    private boolean hasMco(Reservation reservation) {
        return reservation.getProducts().stream().filter(p -> p instanceof Product).map(p -> (Product)p).anyMatch(p -> p.getProductCategory() == ProductCategory.MCO);
    }

    private boolean isCorrectStatus(Reservation reservation) {
        ReservationStatusHandler statusHandler = (ReservationStatusHandler)Environment.getPublished(ReservationStatusHandler.class);
        if (!statusHandler.isCompleted(reservation) && !statusHandler.isExchange(reservation)) {
            return false;
        }
        return reservation.getProducts().stream().filter(Product.class::isInstance).map(Product.class::cast).filter(p -> p.getNextProduct() == null).allMatch(p -> p.getStatus() == ProductStatus.SELL);
    }

    private boolean hasChangedLegs(ExchangeParameters exchangeDetails) {
        return exchangeDetails.getRoute().stream().anyMatch(ExchangeRouteSegment::isChanged);
    }
}

