/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.exchange;

import com.gridnine.xtrip.common.gds.exceptions.ExchangeFlightPriceChangedException;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightPenalty;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.Collectors;

public class CheckExchangeFlightProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        boolean priceChanged;
        Flight selectedFlight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        Flight foundedFlight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.EXCHANGE_SELECTED_FLIGHT);
        boolean bl = priceChanged = !MiscUtil.equals((Object)FlightHelper.calcTotalPrice((Flight)selectedFlight, (ContractType)ContractType.CLIENT), (Object)FlightHelper.calcTotalPrice((Flight)foundedFlight, (ContractType)ContractType.CLIENT)) || !this.isSamePenalties(selectedFlight, foundedFlight);
        if (priceChanged) {
            throw new ExchangeFlightPriceChangedException();
        }
    }

    private boolean isSamePenalties(Flight flight1, Flight flight2) {
        Map<DictionaryReference<PassengerType>, BigDecimal> map1 = this.getPenaltiesMap(flight1);
        Map<DictionaryReference<PassengerType>, BigDecimal> map2 = this.getPenaltiesMap(flight2);
        return CollectionUtil.equals(map1, map2, (boolean)true);
    }

    private Map<DictionaryReference<PassengerType>, BigDecimal> getPenaltiesMap(Flight flight) {
        return flight.getExchangeData().getPenalties().stream().collect(Collectors.toMap(FlightPenalty::getPassengerType, FlightPenalty::getEquivalentAmount));
    }
}

