/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.exchange;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ExchangeHelper {
    public static Product buildExchangeProduct(Product newSellProduct, Product firstSellProduct) throws Exception {
        Product exchangeProduct = AirProductHelper.clone((Product)firstSellProduct, (boolean)false);
        exchangeProduct.setStatus(ProductStatus.EXCHANGE);
        exchangeProduct.setCreatedByParser(true);
        exchangeProduct.getTaxes().clear();
        exchangeProduct.setAddCollectBase(null);
        exchangeProduct.setAddCollectEquivalent(null);
        exchangeProduct.setChecked(false);
        exchangeProduct.setContractRulesApplied(false);
        exchangeProduct.setTotalVendorEquivalentVatAmount(null);
        exchangeProduct.setIssueDate(newSellProduct.getIssueDate());
        exchangeProduct.setBspCommissionRate(null);
        exchangeProduct.setBspCommissionValue(null);
        exchangeProduct.setVendorVatDetalization(null);
        exchangeProduct.setVendorVatCalculated(false);
        ExchangeHelper.updateAgencyData(exchangeProduct, newSellProduct);
        AirProductHelper.clearCommissions((Product)exchangeProduct);
        exchangeProduct.getTaxes().addAll(firstSellProduct.getTaxes());
        exchangeProduct.getObFees().clear();
        ExchangeHelper.removeTaxCPorPenaltyAndCorrectFop(exchangeProduct);
        return exchangeProduct;
    }

    private static void updateAgencyData(Product dstProduct, Product srcProduct) throws Exception {
        dstProduct.setCashier(srcProduct.getCashier());
        dstProduct.setCashierCode(srcProduct.getCashierCode());
        dstProduct.setAgencyCode(srcProduct.getAgencyCode());
        dstProduct.setValidatorCode(srcProduct.getValidatorCode());
        dstProduct.setValidatorRef(srcProduct.getValidatorRef());
        if (srcProduct.getSalesPoint() == null) {
            IncidentsLog.reportStackTrace((String)("\u0412 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0435 " + srcProduct.getSystemNumber() + " \u0437\u0430\u043a\u0430\u0437\u0430 " + srcProduct.getReservation().getBookingFile().getNumber() + " \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436. \u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436 \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430."));
        }
        dstProduct.setSalesPoint(srcProduct.getSalesPoint());
        SalesChain dstSalesChain = AirProductHelper.getSalesChain((Product)dstProduct);
        SalesChain srcSalesChain = AirProductHelper.getSalesChain((Product)srcProduct);
        dstSalesChain.copyFrom((BaseEntity)srcSalesChain, true, new HashMap());
    }

    private static void removeTaxCPorPenaltyAndCorrectFop(Product exchangeProduct) {
        boolean hasCPorPenalty = exchangeProduct.getTaxes().removeIf(tax -> AirProductHelper.isPenaltyTax((DictionaryReference)exchangeProduct.getCarrier(), (Tax)tax));
        if (exchangeProduct.getPenalty() != null) {
            exchangeProduct.setPenalty(null);
            hasCPorPenalty = true;
        }
        if (hasCPorPenalty) {
            AirProductHelper.updateFops((Product)exchangeProduct);
        }
    }

    public static List<Product> getFinalSellProductList(Reservation reservation) {
        return reservation.getProducts().stream().filter(p -> p instanceof Product).map(p -> (Product)p).filter(p -> p.getPreviousProduct() != null && p.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE && p.getNextProduct() == null).collect(Collectors.toList());
    }
}

