/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.exchange;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.ExchangeParameters;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashSet;

public class ExchangeParamsReservationExtractor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        ExchangeParameters exchangeParams = (ExchangeParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.EXCHANGE_PARAMS);
        HashSet reservations = new HashSet();
        BookingHelper.getProductsStream((BookingFile)((BookingFile)bookingCtr.getEntity()), Product.class).filter(p -> exchangeParams.getProductUids().contains(p.getUid())).map(BaseProduct::getReservation).forEach(reservations::add);
        if (reservations.size() != 1) {
            throw Xeption.forDeveloper((String)"multi reservation is not supported", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, reservations.stream().findFirst().get());
    }
}

