/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.exchange;

import com.gridnine.xtrip.common.gds.exceptions.ExchangeFlightNotFoundException;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class FindFlightProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Flight selectedFlight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.EXCHANGE_SELECTED_FLIGHT);
        List flights = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Flight foundedFlight = flights.stream().filter(fl -> this.areSameFlights((Flight)fl, selectedFlight)).findFirst().orElseThrow(ExchangeFlightNotFoundException::new);
        ctx.putObject((Enum)IBusGdsContextKeys.EXCHANGE_SELECTED_FLIGHT, (Object)foundedFlight);
    }

    private boolean areSameFlights(Flight flight1, Flight flight2) {
        List segments1 = FlightHelper.getSegments((Flight)flight1);
        List segments2 = FlightHelper.getSegments((Flight)flight2);
        if (segments1.size() != segments2.size()) {
            return false;
        }
        for (int i = 0; i < segments1.size(); ++i) {
            FlightSegment seg2;
            FlightSegment seg1 = (FlightSegment)segments1.get(i);
            if (this.areSameSegments(seg1, seg2 = (FlightSegment)segments2.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean areSameSegments(FlightSegment seg1, FlightSegment seg2) {
        return MiscUtil.equals((Object)seg1.getFlightNumber(), (Object)seg2.getFlightNumber()) && MiscUtil.equals((Object)seg1.getAirline(), (Object)seg2.getAirline()) && MiscUtil.equals((Object)seg1.getDateBegin(), (Object)seg2.getDateBegin()) && MiscUtil.equals((Object)seg1.getBookingClass(), (Object)seg2.getBookingClass());
    }
}

