/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.exchange;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.ExchangeParameters;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.exchange.ExchangeHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ParseFlightToProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_CLONE);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        ExchangeParameters exchangeParams = (ExchangeParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.EXCHANGE_PARAMS);
        Map flightProductsMap = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.EXCHANGE_FLIGHT_PRODUCTS_MAP);
        Reservation reservation = (Reservation)((BookingFile)bfCtr.getEntity()).getReservations().get(0);
        reservation.setPricingDate(new Date());
        reservation.setRefreshFromGdsDate(new Date());
        reservation.setResDate(new Date());
        reservation.setTimeLimit(flight.getTimeLimit());
        ArrayList<Product> flightProducts = new ArrayList<Product>();
        for (String productUid : exchangeParams.getProductUids()) {
            Product mainProduct = ((BookingFile)bfCtr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(p -> p.getUid().equals(productUid)).map(p -> (Product)p).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find product with uid {0}", (Object[])new Object[]{productUid}));
            Product newSellProduct = this.buildNewSellProduct(flight, mainProduct);
            BookingHelper.addProduct((Reservation)reservation, (BaseProduct)newSellProduct);
            Product exchangeProduct = ExchangeHelper.buildExchangeProduct(newSellProduct, mainProduct);
            BookingHelper.addProduct((Reservation)reservation, (BaseProduct)exchangeProduct);
            mainProduct.setNextProduct(exchangeProduct);
            exchangeProduct.setPreviousProduct(mainProduct);
            exchangeProduct.setNextProduct(newSellProduct);
            newSellProduct.setPreviousProduct(exchangeProduct);
            flightProducts.add(exchangeProduct);
            flightProducts.add(newSellProduct);
        }
        flightProducts.forEach(AirProductHelper::updateFops);
        flightProductsMap.put(flight, flightProducts);
    }

    private Product buildNewSellProduct(Flight flight, Product mainProduct) {
        List flightSegments = FlightHelper.getSegments((Flight)flight);
        Product product = new Product();
        AirProductHelper.setSubagency((Product)product, (EntityReference)AirProductHelper.getSubagency((Product)mainProduct));
        AirProductHelper.setAgency((Product)product, (EntityReference)AirProductHelper.getAgency((Product)mainProduct));
        AirProductHelper.setSupplier((Product)product, (EntityReference)AirProductHelper.getSupplier((Product)mainProduct));
        product.setSalesPoint(mainProduct.getSalesPoint());
        product.setTicketType(TicketType.OWN);
        product.setPassengerType(mainProduct.getPassengerType());
        product.setEticket(true);
        product.setIssueDate(new Date());
        product.setStatus(ProductStatus.SELL);
        product.setCarrier(flight.getCarrier());
        product.setProductCategory(ProductCategory.AIR);
        product.setTariffType(TariffType.REGULAR);
        product.setTraveller(mainProduct.getTraveller());
        product.setGdsCurrency(flight.getGdsCurrencyCode());
        product.setGdsId(mainProduct.getGdsId());
        SegmentTariff st = new SegmentTariff();
        product.getSegmentTariffs().add(st);
        ArrayList<Segment> segmentList = new ArrayList<Segment>();
        for (FlightSegment flightSegment : flightSegments) {
            Segment seg = new Segment();
            seg.setAirline(flightSegment.getAirline());
            seg.setArriveLocation(flightSegment.getLocationEnd());
            seg.setDepartureLocation(flightSegment.getLocationBegin());
            seg.setEndDate(flightSegment.getDateEnd());
            seg.setFlightDuration(Integer.valueOf(flightSegment.getTravelDuration()));
            seg.setFlightNo(flightSegment.getFlightNumber());
            seg.setStartDate(flightSegment.getDateBegin());
            seg.setFareBasis(((FareInfo)flightSegment.getFareInfos().get(0)).getFareBasis());
            if (flightSegment.getOperatingAirline() != null) {
                seg.setCodeShareCarrier(flightSegment.getOperatingAirline());
                seg.setCodeShare(!seg.getCodeShareCarrier().equals((Object)seg.getAirline()));
            } else {
                seg.setCodeShareCarrier(seg.getAirline());
                seg.setCodeShare(false);
            }
            seg.setGdsId(flightSegment.getGdsId());
            seg.setServiceClass(flightSegment.getServiceClass());
            seg.setClassOfSvcCode(flightSegment.getBookingClass());
            segmentList.add(seg);
        }
        segmentList.sort((sOne, sTwo) -> sOne.getEndDate().compareTo(sTwo.getStartDate()));
        st.getSegments().addAll(segmentList);
        ProductFare pf = new ProductFare();
        FlightFare fare = flight.getFares().stream().filter(f -> f.getPassengerType().equals((Object)product.getPassengerType())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find flightFare for {0}", (Object[])new Object[]{product.getPassengerType()}));
        pf.setBaseFare(fare.getBaseAmount());
        pf.setEquivalentFare(fare.getEquivalentAmount());
        for (FlightTax tax : flight.getTaxes()) {
            if (!MiscUtil.equals((Object)tax.getPassengerType(), (Object)product.getPassengerType())) continue;
            this.updateOrAddTaxToProductByTaxCode(product, tax.getCode(), tax.getEquivalentAmount(), flight.getGdsCurrencyCode());
        }
        pf.setSegmentTariff(st);
        product.getFares().add(pf);
        flight.getExchangeData().getPenalties().stream().filter(f -> f.getPassengerType().equals((Object)product.getPassengerType())).findFirst().ifPresent(penalty -> product.setPenalty(penalty.getEquivalentAmount()));
        return product;
    }

    private void updateOrAddTaxToProductByTaxCode(Product product, String taxCode, BigDecimal equivalentAmount, String currencyCode) {
        Tax tax = product.getTaxes().stream().filter(t -> t.getCode().equals(taxCode)).findFirst().orElseGet(() -> {
            Tax t = new Tax();
            product.getTaxes().add(t);
            return t;
        });
        tax.setCode(taxCode);
        BigDecimal taxAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{tax.getEquivalentAmount(), equivalentAmount});
        tax.setEquivalentAmount(taxAmount);
        tax.setAmount(MoneyHelper.buildMoney((BigDecimal)taxAmount, (String)currencyCode));
    }
}

