/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.exchange;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UpdateExchangeFlightCommissionsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Map flightProductsMap = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.EXCHANGE_FLIGHT_PRODUCTS_MAP);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        boolean isSaveRulesTraces = builder != null && gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        HashMap<EntityReference<? extends BaseRulesContainer>, RuleSet> ruleSetMap = new HashMap<EntityReference<? extends BaseRulesContainer>, RuleSet>();
        for (Map.Entry entry : flightProductsMap.entrySet()) {
            Flight flight = (Flight)entry.getKey();
            List products = (List)entry.getValue();
            if (flight == null) continue;
            List passengerTypes = products.stream().map(Product::getPassengerType).distinct().collect(Collectors.toList());
            flight.getContractRelations().clear();
            for (DictionaryReference passengerType : passengerTypes) {
                Product exchange = products.stream().filter(pr -> pr.getStatus() == ProductStatus.EXCHANGE).filter(pr -> MiscUtil.equals((Object)pr.getPassengerType(), (Object)passengerType)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find product with passengerType {0}", (Object[])new Object[]{passengerType}));
                Product newSell = exchange.getNextProduct();
                List exchangeCRs = AirProductHelper.getContractRelations((Product)exchange);
                List newSellCRs = AirProductHelper.getContractRelations((Product)newSell);
                ArrayList<GdsContractRelationData> passengerCRs = new ArrayList<GdsContractRelationData>();
                for (int i = 0; i < exchangeCRs.size(); ++i) {
                    AirProductContractRelationData exchangeCR = (AirProductContractRelationData)exchangeCRs.get(i);
                    AirProductContractRelationData newSellCR = (AirProductContractRelationData)newSellCRs.get(i);
                    GdsContractRelationData passengerCR = new GdsContractRelationData();
                    passengerCR.setDescription(exchangeCR.getDescription());
                    try {
                        XCloneModelHelper.copy((BaseEntity)exchangeCR.getGeneralData(), (BaseEntity)passengerCR.getGeneralData());
                        XCloneModelHelper.copy((BaseEntity)exchangeCR.getServiceData(), (BaseEntity)passengerCR.getServiceData());
                    }
                    catch (Exception e) {
                        throw Xeption.forDeveloper((String)"unable to copy object", (Throwable)e, (Object[])new Object[0]);
                    }
                    newSellCR.getCommissions().stream().map(com -> this.buildFlightCommission((Commission)com, false)).forEach(passengerCR.getCommissions()::add);
                    exchangeCR.getCommissions().stream().map(com -> this.buildFlightCommission((Commission)com, true)).forEach(passengerCR.getCommissions()::add);
                    passengerCRs.add(passengerCR);
                }
                flight.getContractRelations().put(passengerType, passengerCRs);
                if (!isSaveRulesTraces) continue;
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "update exchange contractRelations for passengerType " + passengerType);
                this.saveProductRules(exchange, flight, (GdsTracingItemBuilder<Flight>)builder, ruleSetMap);
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "update newSell contractRelations for passengerType " + passengerType);
                this.saveProductRules(newSell, flight, (GdsTracingItemBuilder<Flight>)builder, ruleSetMap);
            }
        }
    }

    private void saveProductRules(Product product, Flight flight, GdsTracingItemBuilder<Flight> builder, Map<EntityReference<? extends BaseRulesContainer>, RuleSet> ruleSetMap) {
        product.getReservation().getBookingFile().getAppliedRules().stream().filter(r -> MiscUtil.equals((Object)r.getProductUid(), (Object)product.getUid())).forEach(rule -> {
            RuleSettings ruleSettings;
            EntityReference rulesContainerRef = (EntityReference)MiscUtil.guarded((Object)rule.getRulesContainer(), (Object)rule.getContract());
            RuleSet ruleSet = (RuleSet)ruleSetMap.get(rulesContainerRef);
            if (ruleSet == null && !ruleSetMap.containsKey(rulesContainerRef)) {
                ruleSet = ProfileHelper.getRuleSet((EntityContainer)EntityStorage.get().resolve(rulesContainerRef));
                ruleSetMap.put(rulesContainerRef, ruleSet);
            }
            if (ruleSet != null && (ruleSettings = (RuleSettings)CollectionUtil.find((Iterable)ruleSet.getRules(), (String)rule.getRuleUid())) != null) {
                builder.registerAppliedRule((BaseEntity)flight, rulesContainerRef, ruleSettings);
            }
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "applied rule: contract = " + rule.getContract() + ", ruleContainer = " + rule.getRulesContainer() + "; " + rule.getRuleName() + ": " + rule.getRuleDescription());
        });
    }

    private GdsCommission buildFlightCommission(Commission commission, boolean negative) {
        GdsCommission result = FlightHelper.buildGdsCommission((Commission)commission, null);
        if (negative) {
            result.setEquivalentAmount(MiscUtil.negate((BigDecimal)result.getEquivalentAmount()));
            if (result.getAmount() != null) {
                result.getAmount().setValue(MiscUtil.negate((BigDecimal)result.getAmount().getValue()));
            }
        }
        return result;
    }
}

