/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.filter;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExchangeBrandFilter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Collection flights = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHTS);
        if (CollectionUtil.isEmpty((Collection)flights)) {
            return;
        }
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Set<String> brandIds = this.collectBrands(GDSHelper.getAllEffectiveProducts(reservation).stream().flatMap(pr -> AirProductHelper.getSegments((Collection)pr.getSegmentTariffs()).stream()).map(Segment::getFareDetails));
        if (CollectionUtil.isEmpty(brandIds)) {
            return;
        }
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        Iterator iter = flights.iterator();
        while (iter.hasNext()) {
            Flight flight = (Flight)iter.next();
            Set<String> flightBrandIds = this.collectBrands(FlightHelper.getSegments((Flight)flight).stream().flatMap(seg -> seg.getFareInfos().stream()).map(FareInfo::getFareDetails));
            if (brandIds.containsAll(flightBrandIds)) continue;
            iter.remove();
            if (!isSaveRulesTraces) continue;
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("excluded option: flight brands %s are not consistent reservation brands %s", flightBrandIds, brandIds));
        }
    }

    private Set<String> collectBrands(Stream<FareDetails> fareDetailsStream) {
        return fareDetailsStream.filter(Objects::nonNull).map(FareDetails::getPricingParameters).filter(Objects::nonNull).map(FarePricingParameters::getBrandId).filter(TextUtil::nonBlank).collect(Collectors.toSet());
    }
}

