/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.filter;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Iterator;

public class SearchServiceClassFilter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Collection flights = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHTS);
        if (CollectionUtil.isEmpty((Collection)flights)) {
            return;
        }
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        if (fsp == null || fsp.getServiceClass() == null) {
            return;
        }
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        Iterator iter = flights.iterator();
        while (iter.hasNext()) {
            Flight flight = (Flight)iter.next();
            boolean otherServiceClass = FlightHelper.getSegments((Flight)flight).stream().anyMatch(seg -> !MiscUtil.equals((Object)seg.getServiceClass(), (Object)fsp.getServiceClass()));
            if (!otherServiceClass) continue;
            iter.remove();
            if (!isSaveRulesTraces) continue;
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("excluded option from gds %s: service class != %s", flight.getGds().name(), fsp.getServiceClass().name()));
        }
    }
}

