/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.fqtv;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AirlineBonusCardParameters;
import com.gridnine.xtrip.common.gds.model.ModifyAirlineBonusCardsParameters;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.server.gds.ibus.fqtv.IBusGdsFqtvContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;

public class ModifyAirlineBonusCardsInReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ModifyAirlineBonusCardsParameters parameters = (ModifyAirlineBonusCardsParameters)ctx.getMandatoryObject((Enum)IBusGdsFqtvContextKeys.MODIFY_AIRLINE_BONUS_CARDS_PARAMETERS);
        Map<String, List<AirlineBonusCardParameters>> cardsToAdd = parameters.getCardsToAdd().stream().collect(Collectors.groupingBy(abcp -> abcp.getTravellerUid()));
        Map<String, BookingAirlineBonusCard> cardsToUpdate = parameters.getCardsToUpdate().stream().collect(Collectors.toMap(babc -> babc.getUid(), babc -> babc));
        for (Traveller traveller : reservation.getBookingFile().getTravellers()) {
            ListIterator<BookingAirlineBonusCard> iter = traveller.getAirlineBonusCards().listIterator();
            while (iter.hasNext()) {
                String uid = ((BookingAirlineBonusCard)iter.next()).getUid();
                if (parameters.getCardUidsToDelete().contains(uid)) {
                    iter.remove();
                    continue;
                }
                if (!cardsToUpdate.containsKey(uid)) continue;
                iter.set(cardsToUpdate.get(uid));
            }
            if (!cardsToAdd.containsKey(traveller.getUid())) continue;
            traveller.getAirlineBonusCards().addAll(cardsToAdd.get(traveller.getUid()).stream().map(abcp -> abcp.getCard()).collect(Collectors.toList()));
        }
    }
}

