/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.getAviaAirlines;

import com.gridnine.xtrip.common.gds.model.GetAirlinesRequest;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class GetAirlinesProcessor
extends BaseProcessor {
    public static final int LIMIT = 10;

    public void process(MessageContext ctx) throws Exception {
        GetAirlinesRequest request = (GetAirlinesRequest)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GET_AIRLINES_REQUEST);
        Collection requiredCodeVariants = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.AIRLINE_REQUIRED_CODE_VARIANTS);
        Locale locale = LocaleManager.get().getCurrentLocale();
        int limit = 0;
        if (request.getLimit() != null) {
            if (request.getLimit() <= 0) {
                throw Xeption.forDeveloper((String)"limit <= 0", (Object[])new Object[0]);
            }
            if (request.getLimit() > 100) {
                throw Xeption.forDeveloper((String)"limit > 100", (Object[])new Object[0]);
            }
            limit = request.getLimit();
        } else {
            limit = 10;
            ctx.addMessage(MessageHelper.createWarningMessage((String)"\u043b\u0438\u043c\u0438\u0442 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e: '{0}'", (Object[])new Object[]{10}));
        }
        List<Object> searchResult = new ArrayList();
        if (TextUtil.isBlank((String)request.getPattern())) {
            searchResult.addAll(DictionaryCache.get().getAll(Airline.class).values());
        } else {
            String pattern = request.getPattern();
            searchResult.addAll(DictionaryCache.get().lookup(Airline.class, pattern.toUpperCase(locale), new String[0]));
            searchResult.addAll(DictionaryCache.get().search(Airline.class, pattern.toLowerCase(locale)));
        }
        if (requiredCodeVariants != null) {
            searchResult = searchResult.stream().filter(airline -> airline.getCodeVariants().keySet().containsAll(requiredCodeVariants)).collect(Collectors.toList());
        }
        Comparator<Airline> comparator = this.createAirlineComparator(request.getPattern(), locale);
        Collections.sort(searchResult, comparator);
        List result = searchResult.stream().distinct().limit(limit).collect(Collectors.toList());
        ctx.putObject((Enum)IBusGdsContextKeys.GET_AIRLINES_RESPONSE, result);
    }

    private Comparator<Airline> createAirlineComparator(String pattern, Locale locale) {
        return (o1, o2) -> GetAirlinesProcessor.compareAirlines(o1, o2, pattern, locale);
    }

    private static int compareAirlines(Airline o1, Airline o2, String pattern, Locale locale) {
        int result;
        if (TextUtil.isBlank((String)pattern)) {
            return 0;
        }
        if (o1.equals((Object)o2)) {
            return 0;
        }
        if (!o1.getCode().toUpperCase(locale).equalsIgnoreCase(o2.getCode().toUpperCase(locale))) {
            if (o1.getCode().toUpperCase(locale).equalsIgnoreCase(pattern)) {
                return -1;
            }
            if (o2.getCode().toUpperCase(locale).equalsIgnoreCase(pattern)) {
                return 1;
            }
        }
        if (MiscUtil.findByLocale((Map)o1.getTranslations(), (Locale)locale) != null && MiscUtil.findByLocale((Map)o2.getTranslations(), (Locale)locale) != null) {
            if (((String)MiscUtil.findByLocale((Map)o1.getTranslations(), (Locale)locale)).toUpperCase(locale).equalsIgnoreCase(pattern)) {
                return -1;
            }
            if (((String)MiscUtil.findByLocale((Map)o2.getTranslations(), (Locale)locale)).toUpperCase(locale).equalsIgnoreCase(pattern)) {
                return 1;
            }
        }
        if ((result = MiscUtil.compare((int)GetAirlinesProcessor.getPatternPosition(o1, pattern, locale), (int)GetAirlinesProcessor.getPatternPosition(o2, pattern, locale))) != 0) {
            return result;
        }
        result = MiscUtil.compare((Comparable)((Comparable)MiscUtil.findByLocale((Map)o1.getTranslations(), (Locale)locale)), (Comparable)((Comparable)MiscUtil.findByLocale((Map)o2.getTranslations(), (Locale)locale)));
        return result;
    }

    private static int getPatternPosition(Airline airline, String pattern, Locale locale) {
        String name = (String)MiscUtil.findByLocale((Map)airline.getTranslations(), (Locale)locale);
        if (name == null) {
            return Integer.MAX_VALUE;
        }
        int result = name.indexOf(pattern);
        if (result == -1) {
            result = Integer.MAX_VALUE;
        }
        return result;
    }
}

