/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.getAviaLocations;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ResourceUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.getAviaLocations.GetAviaLocationsProcessor;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class GetAviaLocationsProcessorTest
extends ModelTestBase {
    public void setUp() throws Exception {
        super.setUp();
    }

    protected URL getDictionariesSetupFile() {
        return ResourceUtil.getResource(GetAviaLocationsProcessorTest.class, (String)"dictionaries.xml");
    }

    @Test
    public void testSortResults() throws Exception {
        OldSortProcessor oldProcessor = new OldSortProcessor();
        GetAviaLocationsProcessor currentProcessor = new GetAviaLocationsProcessor();
        int limit = 1000;
        Locale locale = LocaleManager.get().getCurrentLocale();
        for (String pattern : Arrays.asList("\u0430", "\u043a", "\u0440", "m")) {
            List<GeoLocation> resultOld = this.getResult(oldProcessor, pattern, limit, locale);
            List<GeoLocation> resultNew = this.getResult(currentProcessor, pattern, limit, locale);
            Assert.assertArrayEquals((String)("failed pattern " + pattern), (Object[])resultOld.toArray(), (Object[])resultNew.toArray());
        }
    }

    private List<GeoLocation> getResult(GetAviaLocationsProcessor processor, String pattern, int limit, Locale locale) {
        ArrayList<Message> messages = new ArrayList<Message>();
        List<List<GeoLocation>> groupedResult = processor.getGroupedResult(pattern, locale, new HashSet<String>(), messages);
        System.out.println("groupedResult.size=" + groupedResult.size());
        long start = System.currentTimeMillis();
        List<GeoLocation> result = processor.getResult(groupedResult, pattern, limit, locale);
        System.out.println("result.size=" + result.size() + "; timing=" + (System.currentTimeMillis() - start));
        return result;
    }

    private static class OldSortProcessor
    extends GetAviaLocationsProcessor {
        @Override
        public List<GeoLocation> getResult(List<List<GeoLocation>> groupedResult, String pattern, int limit, Locale locale) {
            ArrayList<GeoLocation> result = new ArrayList<GeoLocation>();
            Collections.sort(groupedResult, this.createLocationGroupComparator(pattern, locale));
            Comparator<GeoLocation> locationComparator = this.createLocationComparator(pattern, locale);
            block0: for (List<GeoLocation> group : groupedResult) {
                Iterator<GeoLocation> iter = group.iterator();
                while (iter.hasNext()) {
                    GeoLocation location = iter.next();
                    if (location.getType() != LocationType.CITY || DictionaryCache.get().search(GeoLocation.class, DictSearchCriterion.eq((String)GeoLocation.Property.parent.name(), (Object)location.toReference())).size() > 1) continue;
                    iter.remove();
                }
                Collections.sort(group, locationComparator);
                for (GeoLocation member : group) {
                    result.add(member);
                    if (result.size() != limit) continue;
                    break block0;
                }
            }
            return result;
        }

        private Comparator<List<GeoLocation>> createLocationGroupComparator(final String pattern, final Locale locale) {
            return new Comparator<List<GeoLocation>>(){

                @Override
                public int compare(List<GeoLocation> o1, List<GeoLocation> o2) {
                    GeoLocation l2;
                    GeoLocation l1 = this.getLeader(o1);
                    int result = GDSHelper.compareLocationsIgnoreType(l1, l2 = this.getLeader(o2), pattern, locale);
                    return result != 0 ? result : MiscUtil.compare((Comparable)((Object)l1.getCode()), (Comparable)((Object)l2.getCode()));
                }

                private GeoLocation getLeader(List<GeoLocation> group) {
                    if (group.size() == 1) {
                        return group.get(0);
                    }
                    for (GeoLocation member : group) {
                        if (member.getType() != LocationType.CITY) continue;
                        return member;
                    }
                    throw new IllegalStateException("location group had more than 1 member but no city");
                }
            };
        }

        private Comparator<GeoLocation> createLocationComparator(final String pattern, final Locale locale) {
            return new Comparator<GeoLocation>(){

                @Override
                public int compare(GeoLocation o1, GeoLocation o2) {
                    if (o1.getType() == LocationType.CITY) {
                        return -1;
                    }
                    if (o2.getType() == LocationType.CITY) {
                        return 1;
                    }
                    int result = GDSHelper.compareLocationsIgnoreType(o1, o2, pattern, locale);
                    return result != 0 ? result : MiscUtil.compare((Comparable)((Object)o1.getCode()), (Comparable)((Object)o2.getCode()));
                }
            };
        }
    }
}

