/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.getBonusCardsAirlines;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.FrequentTravellerAgreements;
import com.gridnine.xtrip.server.gds.helper.FrequentFlyerHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.fqtv.AirlineBonusCardHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class GetBonusCardsAirlinesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        List<Airline> airlines = this.getAirlinesForBonusCards(flight);
        ctx.putObject((Enum)IBusGdsContextKeys.BONUS_CARDS_AIRLINES, airlines);
    }

    private List<Airline> getAirlinesForBonusCards(Flight flight) {
        Set<DictionaryReference<Airline>> segmentAirlines = AirlineBonusCardHelper.getFlightSegmentAirline(flight);
        HashSet<DictionaryReference<Airline>> flightAirlines = new HashSet<DictionaryReference<Airline>>(segmentAirlines);
        segmentAirlines.stream().filter(Objects::nonNull).forEach(a -> FrequentFlyerHelper.getSegmentPartnerAgreements((DictionaryReference<Airline>)a).stream().filter(Objects::nonNull).map(FrequentTravellerAgreements::getOwningCarrier).filter(Objects::nonNull).forEach(flightAirlines::add));
        return flightAirlines.stream().filter(Objects::nonNull).map(a -> (Airline)DictionaryCache.get().resolveReference(a)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

