/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus.getCouponStatus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.autorefund.AutoRefundHelper;
import com.gridnine.xtrip.server.gds.ibus.getCouponStatus.CouponStatusTranslator;
import com.gridnine.xtrip.server.gds.ibus.getCouponStatus.GetCouponStatusIBusHandler;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class UnsellGetCouponStatusHandler
implements GetCouponStatusIBusHandler {
    @Override
    public Collection<Product> getProducts(MessageContext ctx) {
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map refexRequest = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST);
        ArrayList<Product> result = new ArrayList<Product>();
        for (Product product : AutoRefundHelper.extractRefundableProducts(res, ProductCategory.AIR, ProductCategory.MCO)) {
            if (refexRequest.get(product.getUid()) != ProductStatus.REFUND) continue;
            if (product.getProductCategory() == ProductCategory.MCO) {
                result.add((Product)product.getRelatedProducts().get(0));
                continue;
            }
            result.add(product);
        }
        return result;
    }

    @Override
    public void handle(Product product, List<String> statuses, CouponStatusTranslator translator, MessageContext ctx) {
        Boolean status = (Boolean)ctx.getObject((Enum)IBusGdsContextKeys.ALL_COUPONS_OK_TO_UNSELL);
        if (Boolean.FALSE.equals(status)) {
            return;
        }
        if (status == null) {
            status = Boolean.TRUE;
        }
        if (statuses.stream().anyMatch(s -> !translator.isOkToUnsell((String)s))) {
            status = Boolean.FALSE;
        }
        ctx.putObject((Enum)IBusGdsContextKeys.ALL_COUPONS_OK_TO_UNSELL, (Object)status);
    }
}

